/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.tile.chunk;

import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.batch.BatchTask;
import com.terraforged.core.tile.Tile;
import com.terraforged.core.tile.chunk.ChunkWriter;
import com.terraforged.world.heightmap.Heightmap;
import com.terraforged.world.rivermap.Rivermap;

public class ChunkBatchTask
implements BatchTask {
    private final int x;
    private final int z;
    private final int size;
    private final Tile tile;
    private final Heightmap heightmap;
    private BatchTask.Notifier notifier = BatchTask.NONE;

    public ChunkBatchTask(int x, int z, int size, Tile tile, Heightmap heightmap) {
        this.heightmap = heightmap;
        this.tile = tile;
        this.x = x;
        this.z = z;
        this.size = size;
    }

    @Override
    public void setNotifier(BatchTask.Notifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void run() {
        try {
            this.drive();
        }
        finally {
            this.notifier.markDone();
        }
    }

    private void drive() {
        for (int dz = 0; dz < this.size; ++dz) {
            int cz = this.z + dz;
            if (cz > this.tile.getChunkSize().total) continue;
            for (int dx = 0; dx < this.size; ++dx) {
                int cx = this.x + dx;
                if (cx > this.tile.getChunkSize().total) continue;
                try {
                    this.driveOne(this.tile.getChunkWriter(cx, cz), this.heightmap);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    protected void driveOne(ChunkWriter chunk, Heightmap heightmap) {
        Rivermap rivers = null;
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                Cell cell = chunk.genCell(dx, dz);
                float x = chunk.getBlockX() + dx;
                float z = chunk.getBlockZ() + dz;
                heightmap.applyBase(cell, x, z);
                rivers = Rivermap.get(cell, rivers, heightmap);
                heightmap.applyRivers(cell, x, z, rivers);
                heightmap.applyClimate(cell, x, z);
            }
        }
    }

    public static class Zoom
    extends ChunkBatchTask {
        private final float translateX;
        private final float translateZ;
        private final float zoom;

        public Zoom(int x, int z, int size, Tile tile, Heightmap heightmap, float translateX, float translateZ, float zoom) {
            super(x, z, size, tile, heightmap);
            this.translateX = translateX;
            this.translateZ = translateZ;
            this.zoom = zoom;
        }

        @Override
        protected void driveOne(ChunkWriter chunk, Heightmap heightmap) {
            Rivermap rivers = null;
            for (int dz = 0; dz < 16; ++dz) {
                for (int dx = 0; dx < 16; ++dx) {
                    Cell cell = chunk.genCell(dx, dz);
                    float x = (float)(chunk.getBlockX() + dx) * this.zoom + this.translateX;
                    float z = (float)(chunk.getBlockZ() + dz) * this.zoom + this.translateZ;
                    heightmap.applyBase(cell, x, z);
                    rivers = Rivermap.get(cell, rivers, heightmap);
                    heightmap.applyRivers(cell, x, z, rivers);
                    heightmap.applyClimate(cell, x, z);
                }
            }
        }
    }
}

