/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.core.util;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.heightmap.Levels;
import java.util.function.BiPredicate;

public class VariablePredicate {
    private final Module module;
    private final BiPredicate<Cell, Float> predicate;

    public VariablePredicate(Module module, BiPredicate<Cell, Float> predicate) {
        this.module = module;
        this.predicate = predicate;
    }

    public boolean test(Cell cell, float x, float z) {
        return this.predicate.test(cell, Float.valueOf(this.module.getValue(x, z)));
    }

    public static VariablePredicate height(Seed seed, Levels levels, int min, int max, int size, int octaves) {
        float bias = levels.scale(min);
        float scale = levels.scale(max - min);
        Module source = Source.perlin(seed.next(), size, 1).scale(scale).bias(bias);
        return new VariablePredicate(source, (cell, height) -> cell.value < height.floatValue());
    }
}

