/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm;

import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.biome.BiomeFeature;
import com.terraforged.fm.biome.BiomeFeatures;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;

public interface FeatureDecorator {
    public FeatureManager getFeatureManager();

    default public void decorate(ChunkGenerator<?> generator, WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        int blockX = chunkX << 4;
        int blockZ = chunkZ << 4;
        IChunk chunk = region.func_212866_a_(chunkX, chunkZ);
        BlockPos pos = new BlockPos(blockX, 0, blockZ);
        Biome biome = region.func_225523_d_().func_226836_a_(pos.func_177982_a(8, 8, 8));
        this.decorate(generator, (IWorld)region, chunk, biome, pos);
    }

    default public void decorate(ChunkGenerator<?> generator, IWorld region, IChunk chunk, Biome biome, BlockPos pos) {
        SharedSeedRandom random = new SharedSeedRandom();
        long decorationSeed = random.func_202424_a(region.func_72905_C(), pos.func_177958_n(), pos.func_177952_p());
        BiomeFeatures features = this.getFeatureManager().getFeatures(biome);
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            int featureOrdinal = 0;
            for (BiomeFeature feature : features.getStage(stage)) {
                random.func_202426_b(decorationSeed, featureOrdinal++, stage.ordinal());
                if (!feature.getPredicate().test(chunk, biome)) continue;
                feature.getFeature().func_222734_a(region, generator, (Random)random, pos);
            }
        }
    }
}

