/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template;

import com.terraforged.fm.template.BlockUtils;
import com.terraforged.fm.template.PasteConfig;
import com.terraforged.fm.template.StructureUtils;
import com.terraforged.fm.template.buffer.BufferIterator;
import com.terraforged.fm.template.buffer.PasteBuffer;
import com.terraforged.fm.template.buffer.TemplateBuffer;
import com.terraforged.fm.util.BlockReader;
import com.terraforged.fm.util.ObjectPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;

public class Template {
    private static final int pasteFlag = 19;
    private static final Direction[] directions = Direction.values();
    private final List<BlockInfo> blocks;

    public Template(List<BlockInfo> blocks) {
        this.blocks = blocks;
    }

    public boolean paste(IWorld world, BlockPos origin, Mirror mirror, Rotation rotation, PasteConfig config) {
        IChunk chunk;
        if (config.checkBounds && StructureUtils.hasOvergroundStructure(chunk = world.func_217349_x(origin))) {
            return this.pasteWithBoundsCheck(world, origin, mirror, rotation, config);
        }
        return this.pasteNormal(world, origin, mirror, rotation, config);
    }

    public boolean pasteNormal(IWorld world, BlockPos origin, Mirror mirror, Rotation rotation, PasteConfig config) {
        boolean placed = false;
        try (ObjectPool.Item<PasteBuffer> item = PasteBuffer.retain(config);){
            PasteBuffer buffer = item.getValue();
            BlockReader reader = new BlockReader();
            for (BlockInfo block : this.blocks) {
                BlockState state = block.state.func_185902_a(mirror).func_185907_a(rotation);
                if (!config.pasteAir && state.func_177230_c() == Blocks.field_150350_a) continue;
                BlockPos pos = Template.transform(block.pos, mirror, rotation).func_177971_a((Vec3i)origin);
                if (!config.replaceSolid && BlockUtils.isSolid((IWorldReader)world, pos)) continue;
                if (block.pos.func_177956_o() <= 0 && block.state.func_215686_e((IBlockReader)reader.setState(block.state), BlockPos.field_177992_a)) {
                    this.placeBase(world, pos, block.state, config.baseDepth);
                }
                world.func_180501_a(pos, state, 2);
                buffer.record(pos);
                placed = true;
            }
            Template.updatePostPlacement(world, buffer);
        }
        return placed;
    }

    public boolean pasteWithBoundsCheck(IWorld world, BlockPos origin, Mirror mirror, Rotation rotation, PasteConfig config) {
        try (ObjectPool.Item<TemplateBuffer> item = TemplateBuffer.pooled();){
            BlockReader reader = new BlockReader();
            TemplateBuffer buffer = item.getValue().init(world, origin);
            buffer.configure(config);
            for (BlockInfo block : this.blocks) {
                BlockState state = block.state.func_185902_a(mirror).func_185907_a(rotation);
                BlockPos pos = origin.func_177971_a((Vec3i)Template.transform(block.pos, mirror, rotation));
                buffer.record(pos, state, config);
            }
            boolean placed = false;
            for (BlockInfo block : buffer.getBlocks()) {
                if (block.pos.func_177956_o() <= origin.func_177956_o() && block.state.func_215686_e((IBlockReader)reader.setState(block.state), BlockPos.field_177992_a)) {
                    this.placeBase(world, block.pos, block.state, config.baseDepth);
                    world.func_180501_a(block.pos, block.state, 2);
                    placed = true;
                    continue;
                }
                if (!buffer.test(block.pos)) continue;
                placed = true;
                world.func_180501_a(block.pos, block.state, 2);
                buffer.record(block.pos);
            }
            Template.updatePostPlacement(world, buffer);
            buffer.flush();
            boolean bl = placed;
            return bl;
        }
    }

    private static void updatePostPlacement(IWorld world, BufferIterator iterator) {
        if (iterator.size() > 0) {
            while (iterator.next()) {
                BlockPos pos = iterator.getPos();
                for (Direction direction : directions) {
                    Template.updatePostPlacement(world, pos, direction);
                }
            }
        }
    }

    private static void updatePostPlacement(IWorld world, BlockPos pos1, Direction direction) {
        BlockState result2;
        BlockState state2;
        BlockPos pos2 = pos1.func_177972_a(direction);
        BlockState state1 = world.func_180495_p(pos1);
        BlockState result1 = state1.func_196956_a(direction, state2 = world.func_180495_p(pos2), world, pos1, pos2);
        if (result1 != state1) {
            world.func_180501_a(pos1, result1, 19);
        }
        if ((result2 = state2.func_196956_a(direction.func_176734_d(), result1, world, pos2, pos1)) != state2) {
            world.func_180501_a(pos2, result2, 19);
        }
    }

    private void placeBase(IWorld world, BlockPos pos, BlockState state, int depth) {
        for (int dy = 0; dy < depth; ++dy) {
            if (world.func_180495_p(pos = pos.func_177977_b()).func_200132_m()) {
                return;
            }
            world.func_180501_a(pos, state, 2);
        }
    }

    public static BlockPos transform(BlockPos pos, Mirror mirror, Rotation rotation) {
        return net.minecraft.world.gen.feature.template.Template.func_207669_a((BlockPos)pos, (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.field_177992_a);
    }

    public static Optional<Template> load(InputStream data) {
        try {
            CompoundNBT root = CompressedStreamTools.func_74796_a((InputStream)data);
            if (!root.func_74764_b("palette") || !root.func_74764_b("blocks")) {
                return Optional.empty();
            }
            BlockState[] palette = Template.readPalette(root.func_150295_c("palette", 10));
            BlockInfo[] blockInfos = Template.readBlocks(root.func_150295_c("blocks", 10), palette);
            List<BlockInfo> blocks = Template.relativize(blockInfos);
            return Optional.of(new Template(blocks));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static BlockState[] readPalette(ListNBT list) {
        BlockState[] palette = new BlockState[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            try {
                palette[i] = NBTUtil.func_190008_d((CompoundNBT)list.func_150305_b(i));
                continue;
            }
            catch (Throwable t) {
                palette[i] = Blocks.field_150350_a.func_176223_P();
            }
        }
        return palette;
    }

    private static BlockInfo[] readBlocks(ListNBT list, BlockState[] palette) {
        BlockInfo[] blocks = new BlockInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT compound = list.func_150305_b(i);
            BlockState state = palette[compound.func_74762_e("state")];
            BlockPos pos = Template.readPos(compound.func_150295_c("pos", 3));
            blocks[i] = new BlockInfo(pos, state);
        }
        return blocks;
    }

    private static List<BlockInfo> relativize(BlockInfo[] blocks) {
        BlockPos origin = null;
        int lowestSolid = Integer.MAX_VALUE;
        for (BlockInfo block : blocks) {
            if (!block.state.func_200132_m()) continue;
            if (origin == null) {
                origin = block.pos;
                lowestSolid = block.pos.func_177956_o();
                continue;
            }
            if (block.pos.func_177956_o() < lowestSolid) {
                origin = block.pos;
                lowestSolid = block.pos.func_177956_o();
                continue;
            }
            if (block.pos.func_177956_o() != lowestSolid) continue;
            if (block.pos.func_177958_n() < origin.func_177958_n() && block.pos.func_177952_p() <= origin.func_177952_p()) {
                origin = block.pos;
                lowestSolid = block.pos.func_177956_o();
                continue;
            }
            if (block.pos.func_177952_p() >= origin.func_177952_p() || block.pos.func_177958_n() > origin.func_177958_n()) continue;
            origin = block.pos;
            lowestSolid = block.pos.func_177956_o();
        }
        if (origin == null) {
            return Arrays.asList(blocks);
        }
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>(blocks.length);
        for (BlockInfo in : blocks) {
            BlockPos pos = in.pos.func_177973_b((Vec3i)origin);
            list.add(new BlockInfo(pos, in.state));
        }
        return list;
    }

    private static BlockPos readPos(ListNBT list) {
        int x = list.func_186858_c(0);
        int y = list.func_186858_c(1);
        int z = list.func_186858_c(2);
        return new BlockPos(x, y, z);
    }

    public static class BlockInfo {
        private final BlockPos pos;
        private final BlockState state;

        public BlockInfo(BlockPos pos, BlockState state) {
            this.pos = pos;
            this.state = state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }

        public String toString() {
            return this.state.toString();
        }
    }
}

