/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template.buffer;

import com.terraforged.fm.template.PasteConfig;
import com.terraforged.fm.template.buffer.BufferIterator;
import com.terraforged.fm.util.ObjectPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class PasteBuffer
implements BufferIterator {
    private static final ObjectPool<PasteBuffer> pool = new ObjectPool<PasteBuffer>(8, PasteBuffer::new);
    private boolean updatePostPlacement;
    private List<BlockPos> placedBlocks = Collections.emptyList();
    private int index = -1;
    private BlockPos pos = BlockPos.field_177992_a;

    @Override
    public int size() {
        return this.placedBlocks.size();
    }

    @Override
    public boolean next() {
        while (++this.index < this.placedBlocks.size()) {
            this.pos = this.placedBlocks.get(this.index);
            if (this.pos == BlockPos.field_177992_a) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    public PasteBuffer configure(PasteConfig config) {
        this.updatePostPlacement = config.checkBounds;
        this.placedBlocks.clear();
        this.index = -1;
        return this;
    }

    public void record(BlockPos position) {
        if (this.updatePostPlacement) {
            if (this.placedBlocks.isEmpty()) {
                this.placedBlocks = new ArrayList<BlockPos>();
            }
            this.placedBlocks.add(position);
        }
    }

    public static ObjectPool.Item<PasteBuffer> retain(PasteConfig config) {
        ObjectPool.Item<PasteBuffer> buffer = pool.get();
        buffer.getValue().configure(config);
        return buffer;
    }
}

