/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.template.buffer;

import com.terraforged.fm.template.BlockUtils;
import com.terraforged.fm.template.PasteConfig;
import com.terraforged.fm.template.Template;
import com.terraforged.fm.template.buffer.PasteBuffer;
import com.terraforged.fm.util.ObjectPool;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class TemplateBuffer
extends PasteBuffer {
    private static final ObjectPool<TemplateBuffer> pool = new ObjectPool<TemplateBuffer>(10, TemplateBuffer::new);
    private IWorld world;
    private BlockPos origin;
    private final Set<BlockPos> mask = new HashSet<BlockPos>();
    private final BlockPos.Mutable mutable = new BlockPos.Mutable();
    private final List<Template.BlockInfo> buffer = new LinkedList<Template.BlockInfo>();

    public TemplateBuffer init(IWorld world, BlockPos origin) {
        this.world = world;
        this.origin = origin;
        return this;
    }

    public void flush() {
        this.mask.clear();
        this.buffer.clear();
    }

    public List<Template.BlockInfo> getBlocks() {
        return this.buffer;
    }

    public void record(BlockPos pos, BlockState state, PasteConfig config) {
        if (!config.replaceSolid && BlockUtils.isSolid((IWorldReader)this.world, pos)) {
            this.mask.add(pos);
            return;
        }
        if (!config.pasteAir && state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        this.buffer.add(new Template.BlockInfo(pos, state));
    }

    public boolean test(BlockPos pos) {
        int dz;
        int dx = pos.func_177958_n() - this.origin.func_177958_n();
        if (dx == (dz = pos.func_177952_p() - this.origin.func_177952_p())) {
            return this.test(pos, 1.0f, 1.0f);
        }
        if (Math.abs(dx) > Math.abs(dz)) {
            return this.test(pos, 1.0f, (float)dz / (float)dx);
        }
        return this.test(pos, (float)dx / (float)dz, 1.0f);
    }

    private boolean test(BlockPos start, float dx, float dz) {
        float x = start.func_177958_n();
        float z = start.func_177952_p();
        for (int count = 0; x != (float)this.origin.func_177958_n() && z != (float)this.origin.func_177952_p() && count < 10; x -= dx, z -= dz, ++count) {
            this.mutable.func_189532_c((double)x, (double)start.func_177956_o(), (double)z);
            if (!this.mask.contains(this.mutable)) continue;
            return false;
        }
        return true;
    }

    public static ObjectPool.Item<TemplateBuffer> pooled() {
        return pool.get();
    }
}

