/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.fm.transformer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.terraforged.fm.FeatureSerializer;
import com.terraforged.fm.transformer.FeatureAppender;
import com.terraforged.fm.transformer.FeatureInjector;
import com.terraforged.fm.transformer.FeatureReplacer;
import com.terraforged.fm.transformer.FeatureTransformer;
import com.terraforged.fm.transformer.InjectionPosition;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public class FeatureParser {
    public static Optional<FeatureReplacer> parseReplacer(JsonObject root) {
        if (root.has("replace")) {
            return FeatureSerializer.deserialize(root.get("replace")).map(FeatureReplacer::of);
        }
        return Optional.empty();
    }

    public static Optional<FeatureInjector> parseInjector(JsonObject root) {
        if (root.has("before")) {
            return FeatureSerializer.deserialize(root.get("before")).map(feature -> new FeatureInjector((ConfiguredFeature<?, ?>)feature, InjectionPosition.BEFORE));
        }
        if (root.has("after")) {
            return FeatureSerializer.deserialize(root.get("after")).map(feature -> new FeatureInjector((ConfiguredFeature<?, ?>)feature, InjectionPosition.AFTER));
        }
        return Optional.empty();
    }

    public static Optional<FeatureAppender> parseAppender(JsonObject root) {
        if (root.has("stage")) {
            GenerationStage.Decoration stage = GenerationStage.Decoration.valueOf((String)root.get("stage").getAsString());
            if (root.has("prepend")) {
                return FeatureSerializer.deserialize(root.get("prepend")).map(feature -> new FeatureAppender((ConfiguredFeature<?, ?>)feature, InjectionPosition.HEAD, stage));
            }
            if (root.has("append")) {
                return FeatureSerializer.deserialize(root.get("append")).map(feature -> new FeatureAppender((ConfiguredFeature<?, ?>)feature, InjectionPosition.TAIL, stage));
            }
        }
        return Optional.empty();
    }

    public static Optional<FeatureTransformer> parseTransformer(JsonObject root) {
        if (root.has("transform")) {
            return FeatureParser.parseTransform(root.get("transform"));
        }
        return Optional.empty();
    }

    private static Optional<FeatureTransformer> parseTransform(JsonElement element) {
        if (!element.isJsonObject()) {
            return Optional.empty();
        }
        FeatureTransformer.Builder builder = FeatureTransformer.builder();
        for (Map.Entry e : element.getAsJsonObject().entrySet()) {
            if (((JsonElement)e.getValue()).isJsonPrimitive()) {
                JsonPrimitive key = FeatureParser.keyToPrimitive((String)e.getKey(), ((JsonElement)e.getValue()).getAsJsonPrimitive());
                if (key == null) {
                    return Optional.empty();
                }
                builder.value(key, ((JsonElement)e.getValue()).getAsJsonPrimitive());
                continue;
            }
            builder.key((String)e.getKey(), (JsonElement)e.getValue());
        }
        return Optional.of(builder.build());
    }

    private static JsonPrimitive keyToPrimitive(String key, JsonPrimitive value) {
        if (value.isString()) {
            return new JsonPrimitive(key);
        }
        if (value.isNumber()) {
            return new JsonPrimitive(new JsonPrimitive(key).getAsNumber());
        }
        if (value.isBoolean()) {
            return new JsonPrimitive(Boolean.valueOf(new JsonPrimitive(key).getAsBoolean()));
        }
        return null;
    }
}

