/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.map.set;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.map.defaults.DefaultBiome;
import com.terraforged.mod.biome.map.set.BiomeSet;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.world.biome.BiomeType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BiomeTypeSet
extends BiomeSet {
    public BiomeTypeSet(Map<BiomeType, List<Biome>> map, DefaultBiome defaultBiome) {
        super(BiomeSet.collect(map, BiomeType.values().length, Enum::ordinal), defaultBiome);
    }

    public Biome getBiome(BiomeType type, float temperature, float identity) {
        Biome[] set = this.getSet(type.ordinal());
        if (set.length == 0) {
            return this.defaultBiome.getDefaultBiome(temperature);
        }
        int maxIndex = set.length - 1;
        int index = NoiseUtil.round((float)maxIndex * identity);
        if (index < 0 || index >= set.length) {
            return this.defaultBiome.getDefaultBiome(temperature);
        }
        return set[index];
    }

    @Override
    public int getIndex(Cell cell) {
        return cell.biomeType.ordinal();
    }

    @Override
    public JsonElement toJson() {
        JsonObject root = new JsonObject();
        for (BiomeType type : BiomeType.values()) {
            JsonArray array = new JsonArray();
            root.add(type.name(), (JsonElement)array);
            Stream.of(this.getSet(type.ordinal())).distinct().map(ForgeRegistryEntry::getRegistryName).map(Objects::toString).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        }
        return root;
    }
}

