/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.modifier;

import com.terraforged.api.biome.modifier.BiomeModifier;
import com.terraforged.core.cell.Cell;
import com.terraforged.mod.biome.provider.DesertBiomes;
import net.minecraft.world.biome.Biome;

public class DesertColorModifier
implements BiomeModifier {
    private final DesertBiomes biomes;

    public DesertColorModifier(DesertBiomes biomes) {
        this.biomes = biomes;
    }

    @Override
    public boolean exitEarly() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }

    @Override
    public boolean test(Biome biome, Cell cell) {
        return biome.func_201856_r() == Biome.Category.DESERT || biome.func_201856_r() == Biome.Category.MESA || this.biomes.isDesert(biome);
    }

    @Override
    public Biome modify(Biome in, Cell cell, int x, int z) {
        if (this.biomes.isRedDesert(in)) {
            if (cell.macroNoise <= 0.5f) {
                return this.biomes.getWhiteDesert(cell.biomeIdentity);
            }
        } else if (cell.macroNoise > 0.5f) {
            return this.biomes.getRedDesert(cell.biomeIdentity);
        }
        return in;
    }
}

