/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.provider;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.terraforged.mod.Log;
import com.terraforged.mod.config.ConfigManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeWeights {
    private final int standardWeight;
    private final int forestWeight;
    private final int rareWeight;
    private final Map<ResourceLocation, Integer> biomes = new HashMap<ResourceLocation, Integer>();

    public BiomeWeights() {
        this(10, 5, 1);
    }

    public BiomeWeights(int standard, int forest, int rare) {
        this.standardWeight = standard;
        this.forestWeight = forest;
        this.rareWeight = rare;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            if (entries == null) continue;
            for (BiomeManager.BiomeEntry entry : entries) {
                this.biomes.put(entry.biome.getRegistryName(), entry.field_76292_a);
            }
        }
        this.readWeights();
    }

    public int getWeight(Biome biome) {
        Integer value = this.biomes.get(biome.getRegistryName());
        if (value != null) {
            return value;
        }
        if (BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.RARE)) {
            return this.rareWeight;
        }
        if (biome.func_201856_r() == Biome.Category.FOREST) {
            return this.forestWeight;
        }
        return this.standardWeight;
    }

    public void forEachEntry(BiConsumer<ResourceLocation, Integer> consumer) {
        this.biomes.entrySet().stream().sorted(Comparator.comparing(e -> ((ResourceLocation)e.getKey()).toString())).forEach(e -> consumer.accept((ResourceLocation)e.getKey(), (Integer)e.getValue()));
    }

    public void forEachUnregistered(BiConsumer<ResourceLocation, Integer> consumer) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            if (this.biomes.containsKey(biome.getRegistryName())) continue;
            int weight = this.getWeight(biome);
            consumer.accept(biome.getRegistryName(), weight);
        }
    }

    private void readWeights() {
        CommentedFileConfig config = ConfigManager.BIOME_WEIGHTS.get();
        for (String key : config.valueMap().keySet()) {
            int weight = config.getInt(key);
            if (weight < 0) continue;
            ResourceLocation name = new ResourceLocation(key);
            if (!ForgeRegistries.BIOMES.containsKey(name)) {
                if (key.equals("terraforged:example_biome")) continue;
                Log.err("Invalid biome defined: {}", name);
                continue;
            }
            this.biomes.put(name, weight);
            Log.debug("Loaded custom biome weight: {}={}", name, weight);
        }
    }
}

