/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.spawn;

import com.terraforged.core.cell.Cell;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.TerraBiomeProvider;
import com.terraforged.mod.server.command.search.Search;
import net.minecraft.util.math.BlockPos;

public class SpawnSearch
extends Search {
    private final TerraBiomeProvider biomeProvider;
    private final Cell cell = new Cell();

    public SpawnSearch(BlockPos center, TerraBiomeProvider biomeProvider) {
        super(center, 0, 2048);
        this.biomeProvider = biomeProvider;
    }

    @Override
    public int getSpacing() {
        return 64;
    }

    @Override
    public boolean test(BlockPos pos) {
        this.biomeProvider.getWorldLookup().applyCell(this.cell, pos.func_177958_n(), pos.func_177952_p());
        return this.biomeProvider.canSpawnAt(this.cell);
    }

    @Override
    public BlockPos success(BlockPos.Mutable pos) {
        pos.func_185336_p(this.biomeProvider.getContext().levels.scale(this.cell.value));
        Log.info("Found valid spawn position: {}", pos);
        return super.success(pos);
    }

    @Override
    public BlockPos fail(BlockPos pos) {
        Log.info("Unable to find valid spawn position, defaulting x=0, z=0", new Object[0]);
        return new BlockPos(0, this.biomeProvider.getContext().levels.groundLevel, 0);
    }
}

