/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.api.biome.surface.Surface;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.api.material.state.States;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import com.terraforged.world.GeneratorContext;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;

public class DesertSurface
implements Surface {
    private final float min;
    private final float level;
    private final Module noise;
    private final BlockState sandstone = (BlockState)States.SMOOTH_SANDSTONE.get();
    private final BlockState low;
    private final BlockState mid;
    private final BlockState high;

    public DesertSurface(GeneratorContext context) {
        this.low = ((Block)Blocks.field_150405_ch.delegate.get()).func_176223_P();
        this.mid = ((Block)Blocks.field_196778_fp.delegate.get()).func_176223_P();
        this.high = ((Block)Blocks.field_196719_fA.delegate.get()).func_176223_P();
        this.min = context.levels.ground(10);
        this.level = context.levels.ground(40);
        this.noise = Source.perlin(context.seed.next(), 8, 1).scale(context.levels.scale(16));
    }

    @Override
    public void buildSurface(int x, int z, int height, SurfaceContext ctx) {
        if ((double)ctx.cell.gradient < 0.15) {
            return;
        }
        if (ctx.cell.value < this.min) {
            return;
        }
        float value = ctx.cell.value + this.noise.getValue(x, z);
        if ((double)ctx.cell.gradient > 0.3 || value > this.level) {
            BlockState state = this.sandstone;
            if (value > this.level) {
                if ((double)ctx.cell.gradient > 0.975) {
                    state = this.low;
                } else if ((double)ctx.cell.gradient > 0.85) {
                    state = this.high;
                } else if ((double)ctx.cell.gradient > 0.75) {
                    state = this.mid;
                } else if ((double)ctx.cell.gradient > 0.65) {
                    state = this.low;
                }
            }
            for (int dy = 0; dy < 4; ++dy) {
                ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, height - dy, z), state, false);
            }
        }
    }
}

