/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.surface;

import com.terraforged.api.biome.surface.MaskedSurface;
import com.terraforged.api.biome.surface.SurfaceContext;
import com.terraforged.api.material.state.States;
import com.terraforged.core.Seed;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.Source;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;

public class StoneForestSurface
implements MaskedSurface {
    private final Module module;
    private final BlockState dirt = (BlockState)States.DIRT.get();
    private final BlockState grass;
    private final BlockState stone = (BlockState)States.STONE.get();

    public StoneForestSurface(Seed seed) {
        this.grass = (BlockState)States.GRASS_BLOCK.get();
        this.module = Source.ridge(seed.next(), 50, 4).clamp(0.7, 0.95).map(0.0, 1.0).pow(1.5).terrace(1.0, 0.25, 4, 1.0);
    }

    @Override
    public void buildSurface(int x, int z, int height, float mask, SurfaceContext ctx) {
        float strength = 1.0f - ctx.cell.gradient;
        float value = this.module.getValue(x, z) * mask * strength;
        int top = height + (int)(value * 50.0f);
        if (top > height) {
            for (int y = height; y < top - 1; ++y) {
                ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, y, z), this.stone, false);
            }
            ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, top, z), this.grass, false);
            ctx.buffer.func_177436_a((BlockPos)ctx.pos.func_181079_c(x, top - 1, z), this.dirt, false);
        }
    }
}

