/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.api.biome.surface.SurfaceManager;
import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.tile.Size;
import com.terraforged.core.tile.Tile;
import com.terraforged.core.tile.chunk.ChunkReader;
import com.terraforged.core.tile.gen.TileCache;
import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.data.DataManager;
import com.terraforged.fm.structure.StructureManager;
import com.terraforged.mod.biome.provider.TerraBiomeProvider;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.TerraSetupFactory;
import com.terraforged.mod.chunk.generator.BiomeGenerator;
import com.terraforged.mod.chunk.generator.FeatureGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import com.terraforged.mod.chunk.generator.MobGenerator;
import com.terraforged.mod.chunk.generator.StructureGenerator;
import com.terraforged.mod.chunk.generator.SurfaceGenerator;
import com.terraforged.mod.chunk.generator.TerrainCarver;
import com.terraforged.mod.chunk.generator.TerrainGenerator;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoManager;
import com.terraforged.mod.util.setup.SetupHooks;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class TerraChunkGenerator
extends ChunkGenerator<GenerationSettings> {
    private final TerraContext context;
    private final TerraBiomeProvider biomeProvider;
    private final Generator.Mobs mobGenerator;
    private final Generator.Biomes biomeGenerator;
    private final Generator.Carvers terrainCarver;
    private final Generator.Terrain terrainGenerator;
    private final Generator.Surfaces surfaceGenerator;
    private final Generator.Features featureGenerator;
    private final Generator.Structures structureGenerator;
    private final GeoManager geologyManager;
    private final FeatureManager featureManager;
    private final StructureManager structureManager;
    private final SurfaceManager surfaceManager;
    private final BlockDataManager blockDataManager;
    private final List<ColumnDecorator> baseDecorators;
    private final List<ColumnDecorator> postProcessors;
    private final TileCache tileCache;

    public TerraChunkGenerator(TerraContext context, TerraBiomeProvider biomeProvider, GenerationSettings settings) {
        super(context.world, (BiomeProvider)biomeProvider, settings);
        this.context = context;
        this.biomeProvider = biomeProvider;
        this.mobGenerator = new MobGenerator(this);
        this.biomeGenerator = new BiomeGenerator(this);
        this.terrainCarver = new TerrainCarver(this);
        this.terrainGenerator = new TerrainGenerator(this);
        this.surfaceGenerator = new SurfaceGenerator(this);
        this.featureGenerator = new FeatureGenerator(this);
        this.structureGenerator = new StructureGenerator(this);
        this.surfaceManager = TerraSetupFactory.createSurfaceManager(context);
        this.structureManager = TerraSetupFactory.createStructureManager(context);
        this.geologyManager = TerraSetupFactory.createGeologyManager(context);
        this.baseDecorators = TerraSetupFactory.createBaseDecorators(this.geologyManager, context);
        this.postProcessors = TerraSetupFactory.createFeatureDecorators(context);
        this.tileCache = context.cache;
        try (DataManager data = TerraSetupFactory.createDataManager();){
            FeatureManager.initData(data);
            this.featureManager = TerraSetupFactory.createFeatureManager(data, context);
            this.blockDataManager = TerraSetupFactory.createBlockDataManager(data, context);
            FeatureManager.clearData();
        }
        SetupHooks.setup(this.getLayerManager(), context.copy());
        SetupHooks.setup(this.baseDecorators, this.postProcessors, context.copy());
    }

    public final void func_227058_a_(BiomeManager biomes, IChunk chunk, ChunkGenerator<?> generator, TemplateManager templates) {
        this.structureGenerator.generateStructureStarts(biomes, chunk, templates);
    }

    public final void func_222528_a(IWorld world, IChunk chunk) {
        this.structureGenerator.generateStructureReferences(world, chunk);
    }

    public final void func_222539_a(IChunk chunk) {
        this.biomeGenerator.generateBiomes(chunk);
    }

    public final void func_222537_b(IWorld world, IChunk chunk) {
        this.terrainGenerator.generateTerrain(world, chunk);
    }

    public final void func_225551_a_(WorldGenRegion world, IChunk chunk) {
        this.surfaceGenerator.generateSurface(world, chunk);
    }

    public final void func_202092_b(WorldGenRegion region) {
        this.featureGenerator.generateFeatures(region);
    }

    public final void func_225550_a_(BiomeManager biomes, IChunk chunk, GenerationStage.Carving type) {
        this.terrainCarver.carveTerrain(biomes, chunk, type);
    }

    public final void func_202093_c(WorldGenRegion region) {
        this.mobGenerator.generateMobs(region);
    }

    public final void func_203222_a(ServerWorld worldIn, boolean hostile, boolean peaceful) {
        this.mobGenerator.tickSpawners(worldIn, hostile, peaceful);
    }

    public final List<Biome.SpawnListEntry> func_177458_a(EntityClassification type, BlockPos pos) {
        return this.mobGenerator.getSpawns(this.field_222540_a, type, pos);
    }

    public Biome func_225552_a_(BiomeManager manager, BlockPos pos) {
        return super.func_225552_a_(manager, pos);
    }

    public final int func_222529_a(int x, int z, Heightmap.Type type) {
        int chunkX = Size.blockToChunk(x);
        int chunkZ = Size.blockToChunk(z);
        try (ChunkReader chunk = this.getChunkReader(chunkX, chunkZ);){
            Cell cell = chunk.getCell(x, z);
            int level = this.context.levels.scale(cell.value) + 1;
            if (type == Heightmap.Type.OCEAN_FLOOR || type == Heightmap.Type.OCEAN_FLOOR_WG) {
                int n = level;
                return n;
            }
            int n = Math.max(this.func_222530_f(), level);
            return n;
        }
    }

    public TerraBiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public final int func_207511_e() {
        return this.getContext().levels.worldHeight;
    }

    public final int func_222530_f() {
        return this.getContext().levels.waterLevel;
    }

    public final int func_205470_d() {
        return this.getContext().levels.groundLevel;
    }

    public final TerraContext getContext() {
        return this.context;
    }

    public final Materials getMaterials() {
        return this.context.materials;
    }

    public final FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public final StructureManager getStructureManager() {
        return this.structureManager;
    }

    public final GeoManager getGeologyManager() {
        return this.geologyManager;
    }

    public final LayerManager getLayerManager() {
        return this.context.materials.getLayerManager();
    }

    public final SurfaceManager getSurfaceManager() {
        return this.surfaceManager;
    }

    public final BlockDataManager getBlockDataManager() {
        return this.blockDataManager;
    }

    public final List<ColumnDecorator> getBaseDecorators() {
        return this.baseDecorators;
    }

    public final List<ColumnDecorator> getPostProcessors() {
        return this.postProcessors;
    }

    public final void queueChunk(int chunkX, int chunkZ) {
        int rx = this.tileCache.chunkToRegion(chunkX);
        int rz = this.tileCache.chunkToRegion(chunkZ);
        this.tileCache.queueRegion(rx, rz);
    }

    public final Tile getTile(int chunkX, int chunkZ) {
        int rx = this.tileCache.chunkToRegion(chunkX);
        int rz = this.tileCache.chunkToRegion(chunkZ);
        return this.tileCache.getRegion(rx, rz);
    }

    public final ChunkReader getChunkReader(int chunkX, int chunkZ) {
        return this.tileCache.getChunk(chunkX, chunkZ);
    }

    public static ChunkReader getChunk(IWorld world, ChunkGenerator<?> generator) {
        if (generator instanceof TerraChunkGenerator) {
            TerraChunkGenerator terra = (TerraChunkGenerator)generator;
            if (world instanceof IChunk) {
                IChunk chunk = (IChunk)world;
                return terra.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
            }
            if (world instanceof WorldGenRegion) {
                WorldGenRegion region = (WorldGenRegion)world;
                return terra.getChunkReader(region.func_201679_a(), region.func_201680_b());
            }
        }
        return null;
    }
}

