/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.api.biome.surface.SurfaceManager;
import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.fm.FeatureManager;
import com.terraforged.fm.data.DataManager;
import com.terraforged.fm.matcher.biome.BiomeMatcher;
import com.terraforged.fm.matcher.feature.FeatureMatcher;
import com.terraforged.fm.modifier.FeatureModifiers;
import com.terraforged.fm.predicate.DeepWater;
import com.terraforged.fm.predicate.FeaturePredicate;
import com.terraforged.fm.predicate.MaxHeight;
import com.terraforged.fm.predicate.MinDepth;
import com.terraforged.fm.predicate.MinHeight;
import com.terraforged.fm.structure.StructureManager;
import com.terraforged.fm.transformer.FeatureTransformer;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.ModBiomes;
import com.terraforged.mod.biome.surface.BriceSurface;
import com.terraforged.mod.biome.surface.DesertSurface;
import com.terraforged.mod.biome.surface.ForestSurface;
import com.terraforged.mod.biome.surface.IcebergsSurface;
import com.terraforged.mod.biome.surface.StoneForestSurface;
import com.terraforged.mod.biome.surface.SwampSurface;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.column.BedrockDecorator;
import com.terraforged.mod.chunk.column.ErosionDecorator;
import com.terraforged.mod.chunk.column.GeologyDecorator;
import com.terraforged.mod.chunk.column.post.LayerDecorator;
import com.terraforged.mod.chunk.column.post.SnowEroder;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.feature.Matchers;
import com.terraforged.mod.feature.feature.FreezeLayer;
import com.terraforged.mod.material.geology.GeoManager;
import com.terraforged.mod.util.setup.SetupHooks;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;

public class TerraSetupFactory {
    public static DataManager createDataManager() {
        return FeatureManager.data(new File("config/terraforged/datapacks"));
    }

    public static List<ColumnDecorator> createBaseDecorators(GeoManager geoManager, TerraContext context) {
        ArrayList<ColumnDecorator> processors = new ArrayList<ColumnDecorator>();
        if (context.terraSettings.miscellaneous.strataDecorator) {
            Log.info(" - Geology decorator enabled", new Object[0]);
            processors.add(new GeologyDecorator(geoManager));
        }
        if (context.terraSettings.miscellaneous.erosionDecorator) {
            Log.info(" - Erosion decorator enabled", new Object[0]);
            processors.add(new ErosionDecorator(context));
        }
        processors.add(new BedrockDecorator(context));
        return processors;
    }

    public static List<ColumnDecorator> createFeatureDecorators(TerraContext context) {
        ArrayList<ColumnDecorator> processors = new ArrayList<ColumnDecorator>();
        if (context.terraSettings.miscellaneous.naturalSnowDecorator) {
            Log.info(" - Natural snow decorator enabled", new Object[0]);
            processors.add(new SnowEroder(context));
        }
        if (context.terraSettings.miscellaneous.smoothLayerDecorator) {
            Log.info(" - Smooth layer decorator enabled", new Object[0]);
            processors.add(new LayerDecorator(context.materials.getLayerManager()));
        }
        return processors;
    }

    public static BlockDataManager createBlockDataManager(DataManager data, TerraContext context) {
        return new BlockDataManager(data);
    }

    public static FeatureManager createFeatureManager(DataManager data, TerraContext context) {
        FeatureModifiers modifiers = FeatureManager.modifiers(data, context.terraSettings.miscellaneous.customBiomeFeatures);
        if (context.terraSettings.miscellaneous.strataDecorator) {
            modifiers.getPredicates().add(Matchers.stoneBlobs(), FeaturePredicate.DENY);
        }
        if (!context.terraSettings.miscellaneous.vanillaLakes) {
            modifiers.getPredicates().add(FeatureMatcher.and(Feature.field_202289_ai, Blocks.field_150355_j), FeaturePredicate.DENY);
        }
        if (!context.terraSettings.miscellaneous.vanillaLavaLakes) {
            modifiers.getPredicates().add(FeatureMatcher.and(Feature.field_202289_ai, Blocks.field_150353_l), FeaturePredicate.DENY);
        }
        if (!context.terraSettings.miscellaneous.vanillaSprings) {
            modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202295_ao), FeaturePredicate.DENY);
        }
        if (context.terraSettings.miscellaneous.customBiomeFeatures) {
            modifiers.getPredicates().add(BiomeMatcher.of(Biome.Category.RIVER), Matchers.tree(), FeaturePredicate.DENY);
            modifiers.getTransformers().add(BiomeMatcher.ANY, FeatureMatcher.of(Feature.field_202325_Y), FeatureTransformer.replace(Feature.field_202325_Y, FreezeLayer.INSTANCE));
        }
        modifiers.getPredicates().add(Matchers.sedimentDisks(), FeaturePredicate.DENY);
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202329_g), (FeaturePredicate)new MinHeight(context.levels.waterY + 20));
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202330_h), (FeaturePredicate)new MaxHeight(context.levels.waterY + 64));
        return FeatureManager.create(SetupHooks.setup(modifiers, context.copy()));
    }

    public static SurfaceManager createSurfaceManager(TerraContext context) {
        SurfaceManager manager = new SurfaceManager();
        manager.replace(Biomes.field_203620_Z, new IcebergsSurface(context, 30, 30));
        manager.replace(Biomes.field_76776_l, new IcebergsSurface(context, 20, 15));
        manager.append(ModBiomes.BRYCE, new BriceSurface(context.seed));
        manager.append(ModBiomes.ERODED_PINNACLE, new StoneForestSurface(context.seed));
        manager.append(new DesertSurface(context), Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R);
        manager.replace(new SwampSurface(context), (Biome)Biomes.field_76780_h.delegate.get(), ModBiomes.MARSHLAND);
        manager.append(new ForestSurface(context), Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_150585_R, Biomes.field_185430_ab);
        return SetupHooks.setup(manager, context);
    }

    public static StructureManager createStructureManager(TerraContext context) {
        StructureManager manager = new StructureManager();
        manager.register(Structure.field_202336_n, (FeaturePredicate)DeepWater.INSTANCE);
        manager.register(Structure.field_204029_o, (FeaturePredicate)DeepWater.INSTANCE);
        manager.register(Structure.field_204751_l, (FeaturePredicate)new MinDepth(context.levels.waterLevel - 8));
        return SetupHooks.setup(manager, context);
    }

    public static GeoManager createGeologyManager(TerraContext context) {
        return new GeoManager(context);
    }
}

