/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.column.post;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.api.material.layer.LayerMaterial;
import com.terraforged.core.cell.Cell;
import com.terraforged.world.heightmap.Levels;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.IChunk;

public class LayerDecorator
implements ColumnDecorator {
    private final LayerManager layerManager;

    public LayerDecorator(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        LayerMaterial material;
        context.pos.func_181079_c(x, y + 1, z);
        BlockState state = chunk.func_180495_p((BlockPos)context.pos);
        if (state.isAir((IBlockReader)chunk, (BlockPos)context.pos)) {
            context.pos.func_181079_c(x, y, z);
            state = chunk.func_180495_p((BlockPos)context.pos);
            if (state.isAir((IBlockReader)chunk, (BlockPos)context.pos)) {
                return;
            }
        }
        if ((material = this.layerManager.getMaterial(state.func_177230_c())) == null) {
            return;
        }
        this.setLayer(chunk, (BlockPos)context.pos, material, context.cell, context.levels, 0.0f);
    }

    private void setLayer(IChunk chunk, BlockPos pos, LayerMaterial material, Cell cell, Levels levels, float min) {
        float height = cell.value * (float)levels.worldHeight;
        float depth = material.getDepth(height);
        if (depth > min) {
            int level = material.getLevel(depth);
            BlockState layer = material.getState(level);
            if (layer == LayerMaterial.NONE) {
                return;
            }
            chunk.func_177436_a(pos, layer, false);
        }
    }
}

