/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.generator;

import com.terraforged.fm.predicate.FeaturePredicate;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.generator.Generator;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class StructureGenerator
implements Generator.Structures {
    private final TerraChunkGenerator generator;

    public StructureGenerator(TerraChunkGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void generateStructureStarts(BiomeManager biomes, IChunk chunk, TemplateManager templates) {
        ChunkPos chunkpos = chunk.func_76632_l();
        this.generator.queueChunk(chunkpos.field_77276_a, chunkpos.field_77275_b);
        BlockPos biomePos = new BlockPos(chunkpos.func_180334_c() + 9, 0, chunkpos.func_180333_d() + 9);
        Biome biome = biomes.func_226836_a_(biomePos);
        for (Structure structure : Feature.field_202300_at.values()) {
            FeaturePredicate predicate;
            if (!this.generator.getBiomeProvider().func_205004_a(structure) || !(predicate = this.generator.getStructureManager().getPredicate(structure)).test(chunk, biome)) continue;
            StructureStart existingStart = chunk.func_201585_a(structure.func_143025_a());
            int refCount = existingStart != null ? existingStart.func_227457_j_() : 0;
            SharedSeedRandom random = new SharedSeedRandom();
            StructureStart start = StructureStart.field_214630_a;
            if (structure.func_225558_a_(biomes, (ChunkGenerator)this.generator, (Random)random, chunkpos.field_77276_a, chunkpos.field_77275_b, biome)) {
                StructureStart altStart = structure.func_214557_a().create(structure, chunkpos.field_77276_a, chunkpos.field_77275_b, MutableBoundingBox.func_78887_a(), refCount, this.generator.func_202089_c());
                altStart.func_214625_a((ChunkGenerator)this.generator, templates, chunkpos.field_77276_a, chunkpos.field_77275_b, biome);
                start = altStart.func_75069_d() ? altStart : StructureStart.field_214630_a;
            }
            chunk.func_201584_a(structure.func_143025_a(), start);
        }
    }

    @Override
    public void generateStructureReferences(IWorld world, IChunk chunk) {
        try {
            int radius = 8;
            int chunkX = chunk.func_76632_l().field_77276_a;
            int chunkZ = chunk.func_76632_l().field_77275_b;
            int minX = chunkX << 4;
            int minZ = chunkZ << 4;
            int maxX = minX + 15;
            int maxZ = minZ + 15;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int cx = chunkX + dx;
                    int cz = chunkZ + dz;
                    long chunkSeed = ChunkPos.func_77272_a((int)cx, (int)cz);
                    IChunk c = world.func_212866_a_(cx, cz);
                    for (Map.Entry entry : c.func_201609_c().entrySet()) {
                        StructureStart start = (StructureStart)entry.getValue();
                        if (start == StructureStart.field_214630_a || !start.func_75071_a().func_78885_a(minX, minZ, maxX, maxZ)) continue;
                        chunk.func_201583_a((String)entry.getKey(), chunkSeed);
                        DebugPacketSender.func_218804_a((IWorld)world, (StructureStart)start);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

