/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.mod.Log;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.storage.WorldInfo;

public class SettingsHelper {
    public static final File SETTINGS_DIR = new File("config", "terraforged").getAbsoluteFile();
    public static final File DEFAULTS_FILE = new File(SETTINGS_DIR, "generator-defaults.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void clearDefaults() {
        if (DEFAULTS_FILE.exists() && DEFAULTS_FILE.delete()) {
            Log.info("Deleted generator defaults", new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TerraSettings loadSettings(File file) {
        Throwable throwable;
        TerraSettings settings = new TerraSettings();
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                JsonElement data = new JsonParser().parse((Reader)reader);
                CompoundNBT nbt = NBTHelper.fromJson(data);
                if (NBTHelper.deserialize(nbt, settings)) {
                    TerraSettings terraSettings = settings;
                    return terraSettings;
                }
            }
            catch (Throwable data) {
                throwable = data;
                throw data;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            throwable = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                CompoundNBT tag = NBTHelper.serializeCompact(settings);
                JsonElement json = NBTHelper.toJson(tag);
                GSON.toJson(json, (Appendable)writer);
                return settings;
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return settings;
    }

    public static void exportDefaults(TerraSettings settings) {
        CompoundNBT tag = NBTHelper.serializeCompact(settings);
        JsonElement json = NBTHelper.toJson(tag);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(DEFAULTS_FILE));){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CompoundNBT applyDefaults(CompoundNBT options, TerraSettings dest) {
        if (options.isEmpty()) {
            TerraSettings defaults = SettingsHelper.readDefaults();
            options = NBTHelper.serialize(defaults);
        }
        NBTHelper.deserialize(options, dest);
        return options;
    }

    public static TerraSettings readDefaults() {
        if (DEFAULTS_FILE.exists()) {
            return SettingsHelper.loadSettings(DEFAULTS_FILE);
        }
        return new TerraSettings();
    }

    public static TerraSettings getSettings(WorldInfo info) {
        if (info.func_211027_A().isEmpty()) {
            return SettingsHelper.readDefaults();
        }
        Log.info("Loading generator settings from level.dat", new Object[0]);
        TerraSettings settings = new TerraSettings();
        NBTHelper.deserialize(info.func_211027_A(), settings);
        return settings;
    }

    public static void init() {
        if (!DEFAULTS_FILE.exists()) {
            SettingsHelper.exportDefaults(new TerraSettings());
        }
    }
}

