/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk.util;

import com.terraforged.api.chunk.ChunkDelegate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.Validate;

public class FastChunk
implements ChunkDelegate {
    private static final int arraySize = 256;
    private static final int bitsPerEntry = 9;
    private static final long maxEntryValue = 511L;
    private final int blockX;
    private final int blockZ;
    private final ChunkPrimer primer;
    private final Heightmap worldSurface;
    private final Heightmap oceanSurface;
    private final BlockPos.Mutable mutable = new BlockPos.Mutable();

    private FastChunk(ChunkPrimer primer) {
        this.primer = primer;
        this.blockX = primer.func_76632_l().func_180334_c();
        this.blockZ = primer.func_76632_l().func_180333_d();
        this.worldSurface = primer.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        this.oceanSurface = primer.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
    }

    @Override
    public IChunk getDelegate() {
        return this.primer;
    }

    @Override
    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean falling) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            ChunkSection section = this.primer.func_217332_a(pos.func_177956_o() >> 4);
            section.func_222635_a();
            int dx = pos.func_177958_n() & 0xF;
            int dy = pos.func_177956_o() & 0xF;
            int dz = pos.func_177952_p() & 0xF;
            BlockState replaced = section.func_177484_a(dx, dy, dz, state, false);
            if (state.func_177230_c() != Blocks.field_150350_a) {
                this.mutable.func_181079_c(this.blockX + dx, pos.func_177956_o(), this.blockZ + dz);
                if (state.getLightValue((IBlockReader)this.primer, (BlockPos)this.mutable) != 0) {
                    this.primer.func_201637_h((BlockPos)this.mutable);
                }
                this.worldSurface.func_202270_a(dx, pos.func_177956_o(), dz, state);
                this.oceanSurface.func_202270_a(dx, pos.func_177956_o(), dz, state);
            }
            section.func_222637_b();
            return replaced;
        }
        return Blocks.field_201940_ji.func_176223_P();
    }

    public void fill(BlockState state) {
        int surfaceMinY = 255;
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int y = this.primer.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, dx, dz);
                surfaceMinY = Math.min(surfaceMinY, y);
            }
        }
        int topSection = surfaceMinY >> 4;
        for (int sectionIndex = 0; sectionIndex < topSection; ++sectionIndex) {
            ChunkSection section = this.primer.func_217332_a(sectionIndex);
            section.func_222635_a();
            PalettedContainer container = section.func_186049_g();
            for (int dy = 0; dy < 16; ++dy) {
                for (int dz = 0; dz < 16; ++dz) {
                    for (int dx = 0; dx < 16; ++dx) {
                        container.func_222639_b(dx, dy, dz, (Object)state);
                    }
                }
            }
            section.func_222637_b();
        }
    }

    public void setBiomes(BiomeContainer biomes) {
        this.primer.func_225548_a_(biomes);
    }

    public static IChunk wrap(IChunk chunk) {
        if (chunk instanceof FastChunk) {
            return chunk;
        }
        if (chunk.getClass() == ChunkPrimer.class) {
            return new FastChunk((ChunkPrimer)chunk);
        }
        return chunk;
    }

    public static void updateWGHeightmaps(IChunk chunk, BlockPos.Mutable pos) {
        int topY = chunk.func_76625_h() + 15;
        long[] ocean = chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG).func_202269_a();
        long[] surface = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG).func_202269_a();
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                boolean flag = false;
                for (int y = topY; y >= 0; --y) {
                    BlockState state = chunk.func_180495_p((BlockPos)pos.func_181079_c(x, y, z));
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    if (!flag) {
                        FastChunk.setAt(surface, FastChunk.index(x, z), y + 1);
                        flag = true;
                    }
                    if (!Heightmap.Type.OCEAN_FLOOR_WG.func_222684_d().test(state)) continue;
                    FastChunk.setAt(ocean, FastChunk.index(x, z), y + 1);
                    continue block1;
                }
            }
        }
    }

    private static void setAt(long[] longArray, int index, int value) {
        Validate.inclusiveBetween((long)0L, (long)255L, (long)index);
        Validate.inclusiveBetween((long)0L, (long)511L, (long)value);
        int i = index * 9;
        int j = i >> 6;
        int k = (index + 1) * 9 - 1 >> 6;
        int l = i ^ j << 6;
        longArray[j] = longArray[j] & (511L << l ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & 0x1FFL) << l;
        if (j != k) {
            int i1 = 64 - l;
            int j1 = 9 - i1;
            longArray[k] = longArray[k] >>> j1 << j1 | ((long)value & 0x1FFL) >> i1;
        }
    }

    private static int index(int x, int z) {
        return x + (z << 4);
    }
}

