/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.OverlayRenderer;
import com.terraforged.mod.client.gui.element.CheckBox;
import com.terraforged.mod.client.gui.element.Element;
import com.terraforged.mod.client.gui.preview.PreviewSettings;
import com.terraforged.mod.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class OverlayScreen
extends Screen
implements OverlayRenderer {
    private final CommentedFileConfig config;

    public OverlayScreen() {
        super((ITextComponent)new TranslationTextComponent("", new Object[0]));
        this.minecraft = Minecraft.func_71410_x();
        this.font = this.minecraft.field_71466_p;
        this.config = ConfigManager.GENERAL.get();
        PreviewSettings.showTooltips = (Boolean)this.config.getOrElse("tooltips", (Object)true);
        PreviewSettings.showCoords = (Boolean)this.config.getOrElse("coords", (Object)false);
    }

    public <T extends Widget> T addButton(T buttonIn) {
        return (T)super.addButton(buttonIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (PreviewSettings.showTooltips) {
            this.renderOverlays(this, mouseX, mouseY);
        }
    }

    @Override
    public void renderOverlays(Screen screen, int mouseX, int mouseY) {
        for (Widget button : this.buttons) {
            if (!button.isMouseOver((double)mouseX, (double)mouseY) || !(button instanceof Element)) continue;
            screen.renderTooltip(((Element)button).getTooltip(), mouseX, mouseY);
            return;
        }
    }

    protected void init() {
        this.addButton(new CheckBox(GuiKeys.TOOLTIPS.get(), PreviewSettings.showTooltips){

            @Override
            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                PreviewSettings.showTooltips = this.isChecked();
                OverlayScreen.this.config.set("tooltips", (Object)PreviewSettings.showTooltips);
                OverlayScreen.this.config.save();
            }

            @Override
            public void render(int mouseX, int mouseY, float partial) {
                this.x = OverlayScreen.this.width - this.width - 13;
                this.y = 6;
                super.render(mouseX, mouseY, partial);
            }
        });
        this.addButton(new CheckBox(GuiKeys.COORDS.get(), PreviewSettings.showCoords){

            @Override
            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                PreviewSettings.showCoords = this.isChecked();
                OverlayScreen.this.config.set("coords", (Object)PreviewSettings.showCoords);
                OverlayScreen.this.config.save();
            }

            @Override
            public void render(int mouseX, int mouseY, float partial) {
                this.setChecked(PreviewSettings.showCoords);
                this.x = OverlayScreen.this.width - this.width * 2 - 15;
                this.y = 6;
                super.render(mouseX, mouseY, partial);
            }
        });
    }
}

