/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui;

import com.terraforged.mod.chunk.settings.SettingsHelper;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.Instance;
import com.terraforged.mod.client.gui.OverlayScreen;
import com.terraforged.mod.client.gui.element.TerraLabel;
import com.terraforged.mod.client.gui.page.Page;
import com.terraforged.mod.client.gui.page.PresetsPage;
import com.terraforged.mod.client.gui.page.SimplePage;
import com.terraforged.mod.client.gui.page.SimplePreviewPage;
import com.terraforged.mod.client.gui.page.WorldPage;
import com.terraforged.mod.client.gui.preview.PreviewPage;
import com.terraforged.mod.util.nbt.NBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;

public class SettingsScreen
extends OverlayScreen {
    private static final Button.IPressable NO_ACTION = b -> {};
    private final Page[] pages;
    private final PreviewPage preview;
    private final CreateWorldScreen parent;
    private final Instance instance;
    private int pageIndex = 0;

    public SettingsScreen(CreateWorldScreen parent) {
        TerraSettings settings = new TerraSettings();
        SettingsHelper.applyDefaults(parent.field_146334_a, settings);
        this.parent = parent;
        this.instance = new Instance(settings);
        this.preview = new PreviewPage(this.instance.settings, SettingsScreen.getSeed(parent));
        this.pages = new Page[]{new PresetsPage(this.instance, this.preview, (Widget)this.preview.getPreviewWidget()), new WorldPage(this.instance, this.preview), new SimplePreviewPage(GuiKeys.CLIMATE_SETTINGS, "climate", this.preview, this.instance, s -> s.climate), new SimplePreviewPage(GuiKeys.TERRAIN_SETTINGS, "terrain", this.preview, this.instance, s -> s.terrain), new SimplePreviewPage(GuiKeys.RIVER_SETTINGS, "rivers", this.preview, this.instance, s -> s.rivers), new SimplePreviewPage(GuiKeys.FILTER_SETTINGS, "filters", this.preview, this.instance, s -> s.filters), new SimplePage(GuiKeys.STRUCTURE_SETTINGS, "structures", this.instance, s -> s.structures), new SimplePage(GuiKeys.MISC_SETTINGS, "miscellaneous", this.instance, s -> s.miscellaneous)};
    }

    private boolean isPresetsPage() {
        return this.pages[this.pageIndex] instanceof PresetsPage;
    }

    @Override
    public void init() {
        this.buttons.clear();
        this.children.clear();
        int buttonsCenter = this.width / 2;
        int buttonWidth = 50;
        int buttonHeight = 20;
        int buttonPad = 2;
        int buttonsRow = this.height - 25;
        if (this.pageIndex < this.pages.length) {
            Page page = this.pages[this.pageIndex];
            TerraLabel title = new TerraLabel(page.getTitle());
            title.visible = true;
            title.x = 16;
            title.y = 15;
            this.buttons.add(title);
            try {
                page.initPage(10, 30, this);
                this.preview.initPage(10, 30, this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.addButton(new Button(buttonsCenter - buttonWidth - buttonPad, buttonsRow, buttonWidth, buttonHeight, GuiKeys.CANCEL.get(), b -> this.onClose()));
        this.addButton(new Button(buttonsCenter + buttonPad, buttonsRow, buttonWidth, buttonHeight, GuiKeys.DONE.get(), b -> {
            for (Page page : this.pages) {
                page.save();
            }
            this.parent.field_146334_a = NBTHelper.stripMetadata(this.instance.settingsData);
            SettingsScreen.setSeed(this.parent, this.preview.getSeed());
            this.onClose();
        }));
        this.addButton(new Button(buttonsCenter - (buttonWidth * 2 + buttonPad * 3), buttonsRow, buttonWidth, buttonHeight, "<<", NO_ACTION){

            public void render(int mouseX, int mouseY, float partialTicks) {
                this.active = SettingsScreen.this.hasPrevious();
                super.render(mouseX, mouseY, partialTicks);
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                if (SettingsScreen.this.hasPrevious()) {
                    SettingsScreen.this.pageIndex--;
                    SettingsScreen.this.init();
                }
            }
        });
        this.addButton(new Button(buttonsCenter + buttonWidth + buttonPad * 3, buttonsRow, buttonWidth, buttonHeight, ">>", NO_ACTION){

            public void render(int mouseX, int mouseY, float partialTicks) {
                this.active = SettingsScreen.this.hasNext();
                super.render(mouseX, mouseY, partialTicks);
            }

            public void onClick(double mouseX, double mouseY) {
                super.onClick(mouseX, mouseY);
                if (SettingsScreen.this.hasNext()) {
                    SettingsScreen.this.pageIndex++;
                    SettingsScreen.this.init();
                }
            }
        });
        super.init();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground();
        this.pages[this.pageIndex].visit(pane -> pane.render(mouseX, mouseY, partialTicks));
        if (this.pageIndex > 0) {
            this.preview.visit(pane -> pane.render(mouseX, mouseY, partialTicks));
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderOverlays(Screen screen, int mouseX, int mouseY) {
        super.renderOverlays(screen, mouseX, mouseY);
        this.pages[this.pageIndex].visit(pane -> pane.renderOverlays(screen, mouseX, mouseY));
        if (!this.isPresetsPage()) {
            this.preview.visit(pane -> pane.renderOverlays(screen, mouseX, mouseY));
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseClicked(x, y, button));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.mouseClicked(x, y, button));
        boolean c = this.preview.getPreviewWidget().click(x, y);
        boolean d = super.mouseClicked(x, y, button);
        return a || b || c || d;
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseReleased(x, y, button));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.mouseReleased(x, y, button));
        boolean c = super.mouseReleased(x, y, button);
        return a || b || c;
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseDragged(x, y, button, dx, dy));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.mouseDragged(x, y, button, dx, dy));
        boolean c = super.mouseDragged(x, y, button, dx, dy);
        return a || b || c;
    }

    public boolean mouseScrolled(double x, double y, double direction) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.mouseScrolled(x, y, direction));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.mouseScrolled(x, y, direction));
        boolean c = super.mouseScrolled(x, y, direction);
        return a || b || c;
    }

    public boolean keyPressed(int i, int j, int k) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.keyPressed(i, j, k));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.keyPressed(i, j, k));
        boolean c = super.keyPressed(i, j, k);
        return a || b || c;
    }

    public boolean charTyped(char ch, int code) {
        boolean a = this.pages[this.pageIndex].action(pane -> pane.charTyped(ch, code));
        boolean b = this.isPresetsPage() || this.preview.action(pane -> pane.charTyped(ch, code));
        boolean c = super.charTyped(ch, code);
        return a || b || c;
    }

    public void onClose() {
        for (Page page : this.pages) {
            page.close();
        }
        this.preview.close();
        Minecraft.func_71410_x().func_147108_a((Screen)this.parent);
    }

    private boolean hasNext() {
        return this.pageIndex + 1 < this.pages.length;
    }

    private boolean hasPrevious() {
        return this.pageIndex > 0;
    }

    private static int getSeed(CreateWorldScreen screen) {
        TextFieldWidget field = SettingsScreen.getWidget(screen);
        if (field != null && !field.func_146179_b().isEmpty()) {
            try {
                long seed = Long.parseLong(field.func_146179_b());
                return (int)seed;
            }
            catch (NumberFormatException var6) {
                return field.func_146179_b().hashCode();
            }
        }
        return -1;
    }

    private static void setSeed(CreateWorldScreen screen, int seed) {
        TextFieldWidget field = SettingsScreen.getWidget(screen);
        if (field != null) {
            field.func_146180_a("" + seed);
        }
    }

    private static TextFieldWidget getWidget(CreateWorldScreen screen) {
        String message = I18n.func_135052_a((String)"selectWorld.enterSeed", (Object[])new Object[0]);
        for (IGuiEventListener widget : screen.children()) {
            TextFieldWidget field;
            if (!(widget instanceof TextFieldWidget) || !(field = (TextFieldWidget)widget).getMessage().equals(message)) continue;
            return field;
        }
        return null;
    }
}

