/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.element;

import com.terraforged.mod.client.gui.element.Element;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;

public class TerraTextInput
extends TextFieldWidget
implements Element,
Consumer<String> {
    private final String name;
    private final CompoundNBT value;
    private final List<String> tooltip;
    private String stringValue = "";
    private boolean valid = true;
    private Predicate<String> validator = s -> true;
    private Consumer<TerraTextInput> callback = t -> {};

    public TerraTextInput(String name, CompoundNBT value) {
        super(Minecraft.func_71410_x().field_71466_p, 0, 0, 100, 20, Element.getDisplayName(name, value) + ": ");
        this.name = name;
        this.value = value;
        this.tooltip = Element.getToolTip(name, value);
        this.stringValue = value.func_74779_i(name);
        this.func_146180_a(value.func_74779_i(name));
        this.func_212954_a(this);
        this.func_146184_c(true);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getValue() {
        return this.stringValue;
    }

    public void setColorValidator(Predicate<String> validator) {
        this.validator = validator;
        if (validator.test(this.stringValue)) {
            this.valid = true;
            this.func_146193_g(0xE0E0E0);
        } else {
            this.valid = false;
            this.func_146193_g(-49360);
        }
    }

    public boolean keyPressed(int i, int j, int k) {
        return super.keyPressed(i, j, k);
    }

    public boolean charTyped(char c, int code) {
        return super.charTyped(c, code);
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    @Override
    public void accept(String text) {
        this.value.func_218657_a(this.name, (INBT)StringNBT.func_229705_a_((String)text));
        this.stringValue = text;
        if (this.validator.test(text)) {
            this.valid = true;
            this.func_146193_g(0xE0E0E0);
        } else {
            this.valid = false;
            this.func_146193_g(-49360);
        }
        this.callback.accept(this);
    }
}

