/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.gui.preview;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.cache.CacheEntry;
import com.terraforged.core.concurrent.thread.ThreadPool;
import com.terraforged.core.concurrent.thread.ThreadPools;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.tile.Size;
import com.terraforged.core.tile.Tile;
import com.terraforged.core.tile.gen.TileGenerator;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.preview.PreviewSettings;
import com.terraforged.mod.client.gui.preview.RenderMode;
import com.terraforged.mod.util.nbt.NBTHelper;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.world.GeneratorContext;
import com.terraforged.world.continent.MutableVeci;
import com.terraforged.world.continent.SpawnType;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.terrain.Terrains;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.nbt.CompoundNBT;

public class Preview
extends Button {
    private static final int FACTOR = 4;
    public static final int SIZE = Size.chunkToBlock(16);
    private static final float[] LEGEND_SCALES = new float[]{1.0f, 0.9f, 0.75f, 0.6f};
    private final int offsetX;
    private final int offsetZ;
    private final ThreadPool threadPool = ThreadPools.createDefault();
    private final Random random = new Random(System.currentTimeMillis());
    private final PreviewSettings previewSettings = new PreviewSettings();
    private final DynamicTexture texture = new DynamicTexture(new NativeImage(SIZE, SIZE, true));
    private int seed;
    private long lastUpdate = 0L;
    private MutableVeci center = new MutableVeci();
    private Settings settings = new Settings();
    private CacheEntry<Tile> task = null;
    private Tile tile = null;
    private String hoveredCoords = "";
    private String[] values = new String[]{"", "", ""};
    private String[] labels = new String[]{GuiKeys.PREVIEW_AREA.get(), GuiKeys.PREVIEW_TERRAIN.get(), GuiKeys.PREVIEW_BIOME.get()};

    public Preview(int seed) {
        super(0, 0, 0, 0, "", b -> {});
        this.seed = seed == -1 ? this.random.nextInt() : seed;
        this.offsetX = 0;
        this.offsetZ = 0;
    }

    public int getSeed() {
        return this.seed;
    }

    public void regenerate() {
        this.seed = this.random.nextInt();
    }

    public void close() {
        this.texture.close();
        this.threadPool.shutdown();
    }

    public boolean click(double mx, double my) {
        if (this.updateLegend((int)mx, (int)my) && !this.hoveredCoords.isEmpty()) {
            super.playDownSound(Minecraft.func_71410_x().func_147118_V());
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.hoveredCoords);
            return true;
        }
        return false;
    }

    public void render(int mx, int my, float partialTicks) {
        this.height = this.getSize();
        this.preRender();
        this.texture.func_229148_d_();
        RenderSystem.enableBlend();
        RenderSystem.enableRescaleNormal();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        AbstractGui.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        RenderSystem.disableRescaleNormal();
        this.updateLegend(mx, my);
        this.renderLegend(mx, my, this.labels, this.values, this.x, this.y + this.width, 10, 0xFFFFFF);
    }

    public void update(Settings settings, CompoundNBT prevSettings) {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdate < 50L) {
            return;
        }
        this.lastUpdate = time;
        NBTHelper.deserialize(prevSettings, this.previewSettings);
        settings.world.seed = this.seed;
        this.task = this.generate(settings, prevSettings);
    }

    private int getSize() {
        return this.width;
    }

    private void preRender() {
        if (this.task != null && this.task.isDone()) {
            try {
                this.tile = this.task.get();
                this.render(this.tile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.task = null;
            }
        }
    }

    private void render(Tile tile) {
        NativeImage image = this.texture.func_195414_e();
        if (image == null) {
            return;
        }
        RenderMode renderer = this.previewSettings.display;
        Levels levels = new Levels(this.settings.world);
        int stroke = 2;
        int width = tile.getBlockSize().size;
        tile.iterate((cell, x, z) -> {
            if (x < stroke || z < stroke || x >= width - stroke || z >= width - stroke) {
                image.func_195700_a(x, z, Color.BLACK.getRGB());
            } else {
                image.func_195700_a(x, z, renderer.getColor(cell, levels));
            }
        });
        this.texture.func_110564_a();
    }

    private CacheEntry<Tile> generate(Settings settings, CompoundNBT prevSettings) {
        NBTHelper.deserialize(prevSettings, this.previewSettings);
        settings.world.seed = this.seed;
        this.settings = settings;
        GeneratorContext context = GeneratorContext.createNoCache(Terrains.create(settings), settings);
        if (settings.world.properties.spawnType == SpawnType.CONTINENT_CENTER) {
            context.factory.getHeightmap().getContinent().getNearestCenter(this.offsetX, this.offsetZ, this.center);
        } else {
            this.center.x = 0;
            this.center.z = 0;
        }
        TileGenerator renderer = TileGenerator.builder().pool(this.threadPool).size(4, 0).factory(context.factory).batch(6).build();
        return renderer.getAsync(this.center.x, this.center.z, this.getZoom(), false);
    }

    private boolean updateLegend(int mx, int my) {
        if (this.tile != null) {
            int left = this.x;
            int top = this.y;
            float size = this.width;
            int zoom = this.getZoom();
            int width = Math.max(1, this.tile.getBlockSize().size * zoom);
            int height = Math.max(1, this.tile.getBlockSize().size * zoom);
            this.values[0] = width + "x" + height;
            if (mx >= left && (float)mx <= (float)left + size && my >= top && (float)my <= (float)top + size) {
                float fx = (float)(mx - left) / size;
                float fz = (float)(my - top) / size;
                int ix = NoiseUtil.round(fx * (float)this.tile.getBlockSize().size);
                int iz = NoiseUtil.round(fz * (float)this.tile.getBlockSize().size);
                Cell cell = this.tile.getCell(ix, iz);
                this.values[1] = Preview.getTerrainName(cell);
                this.values[2] = Preview.getBiomeName(cell);
                int dx = (ix - this.tile.getBlockSize().size / 2) * zoom;
                int dz = (iz - this.tile.getBlockSize().size / 2) * zoom;
                this.hoveredCoords = this.center.x + dx + ":" + (this.center.z + dz);
                return true;
            }
            this.hoveredCoords = "";
        }
        return false;
    }

    private float getLegendScale() {
        int index = Minecraft.func_71410_x().field_71474_y.field_74335_Z - 1;
        if (index < 0 || index >= LEGEND_SCALES.length) {
            index = LEGEND_SCALES.length - 1;
        }
        return LEGEND_SCALES[index];
    }

    private void renderLegend(int mx, int my, String[] labels, String[] values, int left, int top, int lineHeight, int color) {
        float scale = this.getLegendScale();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)left + 3.75f * scale), (float)((float)top - (float)lineHeight * (3.2f * scale)), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        FontRenderer renderer = Minecraft.func_71410_x().field_71466_p;
        int spacing = 0;
        for (String s : labels) {
            spacing = Math.max(spacing, renderer.func_78256_a(s));
        }
        float maxWidth = (float)(this.width - 4) / scale;
        for (int i = 0; i < labels.length && i < values.length; ++i) {
            String label = labels[i];
            String value = values[i];
            while (value.length() > 0 && (float)(spacing + renderer.func_78256_a(value)) > maxWidth) {
                value = value.substring(0, value.length() - 1);
            }
            this.drawString(renderer, label, 0, i * lineHeight, color);
            this.drawString(renderer, value, spacing, i * lineHeight, color);
        }
        RenderSystem.popMatrix();
        if (PreviewSettings.showCoords && !this.hoveredCoords.isEmpty()) {
            this.drawCenteredString(renderer, this.hoveredCoords, mx, my - 10, 0xFFFFFF);
        }
    }

    private int getZoom() {
        return NoiseUtil.round(1.5f * (float)(101 - this.previewSettings.zoom));
    }

    private static String getTerrainName(Cell cell) {
        if (cell.terrain.isRiver()) {
            return "river";
        }
        return cell.terrain.getName().toLowerCase();
    }

    private static String getBiomeName(Cell cell) {
        String terrain = cell.terrain.getName().toLowerCase();
        if (terrain.contains("ocean")) {
            if ((double)cell.temperature < 0.3) {
                return "cold_" + terrain;
            }
            if ((double)cell.temperature > 0.6) {
                return "warm_" + terrain;
            }
            return terrain;
        }
        if (terrain.contains("river")) {
            return "river";
        }
        return cell.biomeType.name().toLowerCase();
    }
}

