/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.terraforged.mod.data.WorldGenBiomes;
import com.terraforged.mod.data.WorldGenBlocks;
import com.terraforged.mod.data.WorldGenFeatures;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.minecraft.util.ResourceLocation;

public class DataGen {
    public static void dumpData() {
        File dataDir = new File("data");
        WorldGenBiomes.genBiomeMap(dataDir);
        WorldGenBiomes.genBiomeWeights(dataDir);
        WorldGenBlocks.genBlockTags(dataDir);
        WorldGenFeatures.genBiomeFeatures(dataDir);
    }

    protected static void write(File file, IOConsumer consumer) {
        if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                consumer.accept(writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static void write(JsonElement json, Writer writer) {
        new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(json, (Appendable)writer);
    }

    protected static String getJsonPath(String type, ResourceLocation location) {
        if (location == null) {
            return "unknown";
        }
        return location.func_110624_b() + "/" + type + "/" + location.func_110623_a() + ".json";
    }

    public static interface IOConsumer {
        public void accept(Writer var1) throws IOException;
    }
}

