/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.data;

import com.terraforged.core.util.NameUtil;
import com.terraforged.mod.chunk.settings.TerraSettings;
import com.terraforged.mod.client.gui.GuiKeys;
import com.terraforged.mod.client.gui.preview.PreviewSettings;
import com.terraforged.mod.util.TranslationKey;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.util.function.UnaryOperator;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LangGenerator {
    @SubscribeEvent
    public static void gather(GatherDataEvent event) {
        GuiKeys.init();
        LanguageProvider langProvider = new LanguageProvider(event.getGenerator(), "terraforged", "en_us"){

            protected void addTranslations() {
                LangGenerator.worlds(this);
                LangGenerator.biomes(this);
                LangGenerator.translationKeys(this);
                LangGenerator.settings(this);
            }
        };
        event.getGenerator().func_200390_a((IDataProvider)langProvider);
    }

    private static void worlds(LanguageProvider provider) {
        provider.add("generator.terraforged", "TerraForged");
        provider.add("generator.terratest", "TerraTest");
    }

    private static void biomes(LanguageProvider provider) {
        for (Biome biome : ForgeRegistries.BIOMES) {
            ResourceLocation name = biome.getRegistryName();
            if (name == null || !name.func_110624_b().equals("terraforged")) continue;
            provider.add(biome, NameUtil.toDisplayName(name.func_110623_a()));
        }
    }

    private static void translationKeys(LanguageProvider provider) {
        TranslationKey.each(key -> provider.add(key.getKey(), key.getDefaultValue()));
    }

    private static void settings(LanguageProvider provider) {
        LangGenerator.visit(NBTHelper.serialize(new DataGenSettings()), provider);
    }

    private static void visit(CompoundNBT tag, LanguageProvider lang) {
        tag.func_150296_c().forEach(name -> {
            CompoundNBT meta;
            if (name.startsWith("#")) {
                return;
            }
            INBT value = tag.func_74781_a(name);
            if (value instanceof CompoundNBT) {
                LangGenerator.visit((CompoundNBT)value, lang);
            }
            if ((meta = tag.func_74775_l("#" + name)).isEmpty()) {
                return;
            }
            LangGenerator.add(meta, "key", "display", NameUtil::toDisplayNameKey, lang);
            LangGenerator.add(meta, "key", "comment", NameUtil::toTooltipKey, lang);
        });
    }

    private static void add(CompoundNBT tag, String keyName, String valName, UnaryOperator<String> keyFunc, LanguageProvider lang) {
        String key = (String)keyFunc.apply(tag.func_74779_i(keyName));
        if (key.isEmpty()) {
            return;
        }
        String value = tag.func_74779_i(valName);
        if (value.isEmpty()) {
            return;
        }
        lang.add(key, value);
    }

    public static class DataGenSettings
    extends TerraSettings {
        public PreviewSettings preview = new PreviewSettings();
    }
}

