/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature;

import com.google.common.collect.ImmutableSet;
import com.terraforged.n2d.util.NoiseUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class TerrainHelper {
    private static final Set<IStructurePieceType> SURFACE_STRUCTURES = ImmutableSet.of((Object)IStructurePieceType.field_214784_e, (Object)IStructurePieceType.field_214785_f, (Object)IStructurePieceType.field_214762_I, (Object)IStructurePieceType.field_214764_K, (Object)IStructurePieceType.field_214766_M);
    private final float radius;
    private final float overhang;
    private final float overhang2;

    public TerrainHelper(float base, float cutout) {
        this.radius = base;
        this.overhang = cutout;
        this.overhang2 = cutout * cutout;
    }

    public void flatten(IWorld world, IChunk chunk) {
        ObjectArrayList pieces = new ObjectArrayList(10);
        this.collectPieces(world, chunk, (ObjectList<StructurePiece>)pieces);
        this.buildBases(chunk, (ObjectList<StructurePiece>)pieces);
    }

    private void collectPieces(IWorld world, IChunk chunk, ObjectList<StructurePiece> pieces) {
        ChunkPos pos = chunk.func_76632_l();
        for (Structure structure : Structure.field_214488_aQ) {
            String name = structure.func_143025_a();
            LongIterator structureIds = chunk.func_201578_b(name).iterator();
            while (structureIds.hasNext()) {
                long id = structureIds.nextLong();
                ChunkPos structurePos = new ChunkPos(id);
                IChunk neighbourChunk = world.func_217349_x(structurePos.func_206849_h());
                StructureStart structurestart = neighbourChunk.func_201585_a(name);
                if (structurestart == null || !structurestart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structurestart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(pos, 12)) continue;
                    TerrainHelper.collectPiece(structurepiece, pieces);
                }
            }
        }
    }

    private void buildBases(IChunk chunk, ObjectList<StructurePiece> pieces) {
        int chunkStartX = chunk.func_76632_l().func_180334_c();
        int chunkStartZ = chunk.func_76632_l().func_180333_d();
        BlockPos.Mutable pos = new BlockPos.Mutable();
        ObjectListIterator iterator = pieces.iterator();
        MutableBoundingBox chunkBounds = new MutableBoundingBox(chunkStartX, chunkStartZ, chunkStartX + 15, chunkStartZ + 15);
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                MutableBoundingBox bounds;
                int x = chunkStartX + dx;
                int z = chunkStartZ + dz;
                int surface = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, dx, dz);
                float y = surface;
                int highestOffset = 0;
                StructurePiece highest = null;
                while (iterator.hasNext()) {
                    int length;
                    int borderRadius;
                    StructurePiece piece = (StructurePiece)iterator.next();
                    MutableBoundingBox pieceBounds = piece.func_74874_b();
                    MutableBoundingBox expanded = TerrainHelper.expand(pieceBounds, borderRadius = Math.min(5, Math.max(10, NoiseUtil.round((float)(length = Math.min(pieceBounds.field_78893_d - pieceBounds.field_78897_a, pieceBounds.field_78892_f - pieceBounds.field_78896_c)) * this.radius))));
                    if (!expanded.func_78884_a(chunkBounds)) continue;
                    int offset = TerrainHelper.getGroundLevelDelta(piece);
                    int level = pieceBounds.field_78895_b + offset;
                    if ((float)level > y) {
                        y = this.raise(pieceBounds, pos.func_181079_c(x, surface, z), level, y, borderRadius);
                    }
                    if (x <= pieceBounds.field_78897_a || x >= pieceBounds.field_78893_d || z <= pieceBounds.field_78896_c || z >= pieceBounds.field_78892_f || highest != null && pieceBounds.field_78895_b <= highest.func_74874_b().field_78895_b) continue;
                    highest = piece;
                    highestOffset = offset;
                }
                iterator.back(pieces.size());
                if (y > (float)surface) {
                    int delta = (int)y - surface;
                    for (int dy = 0; dy < delta; ++dy) {
                        pos.func_181079_c(dx, surface + dy, dz);
                        chunk.func_177436_a((BlockPos)pos, Blocks.field_150348_b.func_176223_P(), false);
                    }
                }
                if (highest == null) continue;
                int minY = bounds.field_78895_b + highestOffset;
                bounds = highest.func_74874_b();
                int maxY = minY + bounds.func_78882_c();
                if (maxY <= surface) {
                    float dist = this.getCenterDistance2(x, z, bounds);
                    float distAlpha = 1.0f - NoiseUtil.clamp(dist / this.overhang2, 0.0f, 1.0f);
                    float depth = surface - maxY;
                    float depthAlpha = 1.0f - NoiseUtil.clamp(depth / this.overhang, 0.0f, 1.0f);
                    maxY += NoiseUtil.round(depthAlpha * distAlpha * this.overhang);
                }
                for (int dy = minY; dy <= maxY; ++dy) {
                    pos.func_181079_c(dx, dy, dz);
                    chunk.func_177436_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), false);
                }
            }
        }
    }

    private float raise(MutableBoundingBox bounds, BlockPos.Mutable pos, float level, float surface, int borderRadius) {
        float radius2 = Math.max(1, borderRadius * borderRadius);
        float alpha = 1.0f - TerrainHelper.getDistAlpha(pos.func_177958_n(), pos.func_177952_p(), bounds, radius2);
        alpha = (float)Math.pow(alpha, 2.0f - alpha);
        return NoiseUtil.lerp(surface, level, alpha);
    }

    private float getCenterDistance2(int x, int z, MutableBoundingBox bounds) {
        float cx = (float)bounds.field_78897_a + (float)bounds.func_78883_b() / 2.0f;
        float cz = (float)bounds.field_78896_c + (float)bounds.func_78880_d() / 2.0f;
        float dx = cx - (float)x;
        float dz = cz - (float)z;
        return dx * dx + dz * dz;
    }

    private static void collectPiece(StructurePiece structurepiece, List<StructurePiece> list) {
        if (structurepiece instanceof AbstractVillagePiece) {
            AbstractVillagePiece piece = (AbstractVillagePiece)structurepiece;
            JigsawPattern.PlacementBehaviour placement = piece.func_214826_b().func_214854_c();
            if (placement == JigsawPattern.PlacementBehaviour.RIGID) {
                list.add((StructurePiece)piece);
            }
        } else if (SURFACE_STRUCTURES.contains(structurepiece.func_214807_k())) {
            list.add(structurepiece);
        }
    }

    private static int getGroundLevelDelta(StructurePiece piece) {
        if (piece instanceof AbstractVillagePiece) {
            return ((AbstractVillagePiece)piece).func_214830_d();
        }
        return 0;
    }

    private static MutableBoundingBox expand(MutableBoundingBox box, int radius) {
        return new MutableBoundingBox(box.field_78897_a - radius, box.field_78895_b, box.field_78896_c - radius, box.field_78893_d + radius, box.field_78894_e, box.field_78892_f + radius);
    }

    private static float getDistAlpha(int x, int z, MutableBoundingBox box, float radius2) {
        int dx;
        int n = x < box.field_78897_a ? box.field_78897_a - x : (dx = x > box.field_78893_d ? x - box.field_78893_d : 0);
        int dz = z < box.field_78896_c ? box.field_78896_c - z : (z > box.field_78892_f ? z - box.field_78892_f : 0);
        int d2 = dx * dx + dz * dz;
        if (d2 == 0) {
            return 0.0f;
        }
        if ((float)d2 > radius2) {
            return 1.0f;
        }
        return (float)d2 / radius2;
    }
}

