/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.decorator.poisson;

import com.terraforged.core.util.poisson.Poisson;
import com.terraforged.mod.feature.decorator.poisson.PoissonConfig;
import com.terraforged.mod.feature.decorator.poisson.PoissonVisitor;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.Placement;

public abstract class PoissonDecorator
extends Placement<PoissonConfig> {
    private Poisson instance = null;
    private final Object lock = new Object();

    public PoissonDecorator() {
        super(PoissonConfig::deserialize);
    }

    public <FC extends IFeatureConfig, F extends Feature<FC>> boolean place(IWorld world, ChunkGenerator<?> generator, Random random, BlockPos pos, PoissonConfig config, ConfiguredFeature<FC, F> feature) {
        int radius = Math.max(1, Math.min(30, config.radius));
        Poisson poisson = this.getInstance(radius);
        PoissonVisitor visitor = new PoissonVisitor(this, feature, world, generator, random, pos);
        config.apply(world, generator, visitor);
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        poisson.visit(chunkX, chunkZ, visitor, visitor);
        return visitor.hasPlacedOne();
    }

    public final Stream<BlockPos> getPositions(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generatorIn, Random random, PoissonConfig configIn, BlockPos pos) {
        return Stream.empty();
    }

    public abstract int getYAt(IWorld var1, BlockPos var2, Random var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Poisson getInstance(int radius) {
        Object object = this.lock;
        synchronized (object) {
            if (this.instance == null || this.instance.getRadius() != radius) {
                this.instance = new Poisson(radius);
            }
            return this.instance;
        }
    }
}

