/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.terraforged.fm.template.BlockUtils;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class BushFeature
extends Feature<Config> {
    public static final BushFeature INSTANCE = new BushFeature();
    private static final Vec3i[] logs = new Vec3i[]{new Vec3i(1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 1), new Vec3i(2, 0, 1), new Vec3i(2, 0, -1), new Vec3i(-2, 0, 1), new Vec3i(-2, 0, -1), new Vec3i(1, 0, 2), new Vec3i(1, 0, -2), new Vec3i(-1, 0, 2), new Vec3i(-1, 0, -2)};
    private static final Vec3i[] leaves = new Vec3i[]{new Vec3i(0, 0, 1), new Vec3i(0, 0, -1), new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 1, 0)};

    public BushFeature() {
        super(BushFeature::deserialize);
        this.setRegistryName("terraforged", "bush");
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, Config config) {
        try (BlockPos.PooledMutable log = BlockPos.PooledMutable.func_185346_s();
             BlockPos.PooledMutable leaf = BlockPos.PooledMutable.func_185346_s();){
            this.place(world, (BlockPos.Mutable)log.func_189533_g((Vec3i)pos), (BlockPos.Mutable)leaf, rand, config);
            for (float chance = rand.nextFloat(); chance < config.size_chance; chance += rand.nextFloat()) {
                BushFeature.add((BlockPos.Mutable)log, logs[rand.nextInt(logs.length)]);
                if (this.place(world, (BlockPos.Mutable)log, (BlockPos.Mutable)leaf, rand, config)) continue;
                break;
            }
        }
        return true;
    }

    private boolean place(IWorld world, BlockPos.Mutable center, BlockPos.Mutable pos, Random random, Config config) {
        center.func_185336_p(world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, center.func_177958_n(), center.func_177952_p()));
        if (BlockUtils.isSolid((IWorldReader)world, (BlockPos)center)) {
            return false;
        }
        center.func_189534_c(Direction.DOWN, 1);
        if (!BlockUtils.isSolid((IWorldReader)world, (BlockPos)center)) {
            return false;
        }
        center.func_189534_c(Direction.UP, 1);
        world.func_180501_a((BlockPos)center, config.trunk, 2);
        for (Vec3i neighbour : leaves) {
            if (neighbour.func_177956_o() == 0 && random.nextFloat() < config.airChance) continue;
            pos.func_189533_g((Vec3i)center);
            BushFeature.add(pos, neighbour);
            if (BlockUtils.isSolid((IWorldReader)world, (BlockPos)pos)) continue;
            world.func_180501_a((BlockPos)pos, config.leaves, 2);
            if (neighbour.func_177956_o() == 0 && random.nextFloat() < config.leafChance) {
                pos.func_189534_c(Direction.DOWN, 1);
                if (!BlockUtils.isSolid((IWorldReader)world, (BlockPos)pos)) {
                    world.func_180501_a((BlockPos)pos, config.leaves, 2);
                }
                pos.func_189534_c(Direction.UP, 1);
            }
            if (neighbour.func_177956_o() != 0 || !(random.nextFloat() < config.leafChance)) continue;
            pos.func_189534_c(Direction.UP, 1);
            if (BlockUtils.isSolid((IWorldReader)world, (BlockPos)pos)) continue;
            world.func_180501_a((BlockPos)pos, config.leaves, 2);
        }
        return true;
    }

    private static void add(BlockPos.Mutable pos, Vec3i add) {
        pos.func_181079_c(pos.func_177958_n() + add.func_177958_n(), pos.func_177956_o() + add.func_177956_o(), pos.func_177952_p() + add.func_177952_p());
    }

    public static Config deserialize(Dynamic<?> data) {
        BlockState logs = BlockState.func_215698_a((Dynamic)((Dynamic)data.get("trunk").get().get()));
        BlockState leaves = BlockState.func_215698_a((Dynamic)((Dynamic)data.get("leaves").get().get()));
        float airChance = data.get("air_chance").asFloat(0.075f);
        float leafChance = data.get("leaf_chance").asFloat(0.075f);
        float sizeChance = data.get("size_chance").asFloat(0.75f);
        return new Config(logs, leaves, airChance, leafChance, sizeChance);
    }

    public static class Config
    implements IFeatureConfig {
        private final BlockState trunk;
        private final BlockState leaves;
        private final float airChance;
        private final float leafChance;
        private final float size_chance;

        public Config(BlockState trunk, BlockState leaves, float airChance, float leafChance, float size_chance) {
            this.trunk = trunk;
            this.leaves = leaves;
            this.airChance = airChance;
            this.leafChance = leafChance;
            this.size_chance = size_chance;
        }

        public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
            return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("trunk"), (Object)BlockState.func_215689_a(ops, (BlockState)this.trunk).getValue(), (Object)ops.createString("leaves"), (Object)BlockState.func_215689_a(ops, (BlockState)this.leaves).getValue(), (Object)ops.createString("air_chance"), (Object)ops.createFloat(this.airChance), (Object)ops.createString("leaf_chance"), (Object)ops.createFloat(this.airChance), (Object)ops.createString("size_chance"), (Object)ops.createFloat(this.size_chance))));
        }
    }
}

