/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.feature.sapling;

import com.terraforged.fm.template.Template;
import com.terraforged.fm.template.feature.TemplateFeature;
import com.terraforged.fm.template.feature.TemplateFeatureConfig;
import com.terraforged.mod.TerraWorld;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.feature.BlockDataManager;
import com.terraforged.mod.feature.sapling.SaplingConfig;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SaplingListener {
    private static final BlockPos[] CENTER = new BlockPos[]{BlockPos.field_177992_a};
    private static final Vec3i[][] DIRECTIONS = new Vec3i[][]{{new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(1, 0, 0)}, {new Vec3i(1, 0, 0), new Vec3i(1, 0, -1), new Vec3i(0, 0, -1)}, {new Vec3i(0, 0, -1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 0)}, {new Vec3i(-1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1)}};

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTreeGrow(SaplingGrowTreeEvent event) {
        Optional<BlockDataManager> dataManager = SaplingListener.getDataManger(event);
        if (!dataManager.isPresent()) {
            return;
        }
        IWorld world = event.getWorld();
        Block block = world.func_180495_p(event.getPos()).func_177230_c();
        Optional<SaplingConfig> saplingConfig = dataManager.get().getConfig(block, SaplingConfig.class);
        if (!saplingConfig.isPresent()) {
            return;
        }
        Mirror mirror = TemplateFeature.nextMirror(event.getRand());
        Rotation rotation = TemplateFeature.nextRotation(event.getRand());
        BlockPos pos = SaplingListener.getMinPos(world, block, event.getPos(), saplingConfig.get().hasGiant());
        Vec3i[] directions = SaplingListener.getNeighbours(world, block, pos, saplingConfig.get().hasGiant());
        TemplateFeatureConfig feature = saplingConfig.get().next(event.getRand(), directions.length == 3);
        if (feature == null) {
            return;
        }
        Vec3i translation = SaplingListener.getTranslation(directions, mirror, rotation);
        BlockPos origin = pos.func_177973_b(translation);
        if (!SaplingListener.isClearOverhead(world, origin, directions)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (TemplateFeature.pasteChecked(world, event.getRand(), origin, mirror, rotation, feature, feature.decorator)) {
            event.setResult(Event.Result.DENY);
            for (Vec3i dir : directions) {
                BlockPos neighbour = origin.func_177971_a(dir);
                BlockState state = world.func_180495_p(neighbour);
                if (state.func_177230_c() != block) continue;
                world.func_175655_b(neighbour, false);
            }
        }
    }

    private static Optional<BlockDataManager> getDataManger(SaplingGrowTreeEvent event) {
        if (event.getWorld().func_201670_d()) {
            return Optional.empty();
        }
        if (!TerraWorld.isTerraWorld(event.getWorld())) {
            return Optional.empty();
        }
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ChunkGenerator generator = serverWorld.func_72863_F().field_186029_c;
            if (generator instanceof TerraChunkGenerator) {
                TerraContext context = ((TerraChunkGenerator)generator).getContext();
                if (context.terraSettings.miscellaneous.customBiomeFeatures) {
                    return Optional.of(((TerraChunkGenerator)generator).getBlockDataManager());
                }
            }
        }
        return Optional.empty();
    }

    private static boolean isClearOverhead(IWorld world, BlockPos pos, Vec3i[] directions) {
        for (Vec3i dir : directions) {
            int z;
            int x = pos.func_177958_n() + dir.func_177958_n();
            int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z = pos.func_177952_p() + dir.func_177952_p());
            if (y <= pos.func_177956_o()) continue;
            return false;
        }
        return true;
    }

    private static BlockPos getMinPos(IWorld world, Block block, BlockPos pos, boolean checkNeighbours) {
        if (checkNeighbours) {
            for (Vec3i[] dirs : DIRECTIONS) {
                boolean match = true;
                for (Vec3i dir : dirs) {
                    BlockState state = world.func_180495_p(pos.func_177971_a(dir));
                    if (state.func_177230_c() == block) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                Vec3i min = SaplingListener.getMin(dirs, Mirror.NONE, Rotation.NONE);
                return pos.func_177971_a(min);
            }
        }
        return pos;
    }

    private static Vec3i getTranslation(Vec3i[] directions, Mirror mirror, Rotation rotation) {
        if (directions.length == 1 || mirror == Mirror.NONE && rotation == Rotation.NONE) {
            return Vec3i.field_177959_e;
        }
        return SaplingListener.getMin(directions, mirror, rotation);
    }

    private static Vec3i getMin(Vec3i[] directions, Mirror mirror, Rotation rotation) {
        int minX = 0;
        int minZ = 0;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (Vec3i vec : directions) {
            BlockPos dir = Template.transform((BlockPos)pos.func_189533_g(vec), mirror, rotation);
            minX = Math.min(dir.func_177958_n(), minX);
            minZ = Math.min(dir.func_177952_p(), minZ);
        }
        return new Vec3i(minX, 0, minZ);
    }

    private static Vec3i[] getNeighbours(IWorld world, Block block, BlockPos pos, boolean checkNeighbours) {
        if (checkNeighbours) {
            for (Vec3i[] dirs : DIRECTIONS) {
                boolean match = true;
                for (Vec3i dir : dirs) {
                    BlockState state = world.func_180495_p(pos.func_177971_a(dir));
                    if (state.func_177230_c() == block) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return dirs;
            }
        }
        return CENTER;
    }
}

