/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.material;

import com.terraforged.api.material.WGTags;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.api.material.state.States;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.mod.util.DummyBlockReader;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.MyceliumBlock;
import net.minecraft.tags.Tag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Materials {
    private static final Comparator<IForgeRegistryEntry<?>> COMPARATOR = Comparator.comparing(IForgeRegistryEntry::getRegistryName);
    public final LayerManager layerManager = new LayerManager();
    public final Set<Block> stone = Materials.create(WGTags.STONE, States.STONE.getBlock());
    public final Set<Block> dirt = Materials.create(WGTags.DIRT, States.DIRT.getBlock());
    public final Set<Block> clay = Materials.create(WGTags.CLAY, States.CLAY.getBlock());
    public final Set<Block> sediment = Materials.create(WGTags.SEDIMENT, States.GRAVEL.getBlock());
    public final Set<Block> erodible = Materials.create(WGTags.ERODIBLE, null);

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public boolean isStone(Block block) {
        return this.stone.contains(block);
    }

    public boolean isEarth(Block block) {
        return this.dirt.contains(block);
    }

    public boolean isClay(Block block) {
        return this.clay.contains(block);
    }

    public boolean isSediment(Block block) {
        return this.sediment.contains(block);
    }

    public boolean isErodible(Block block) {
        return this.erodible.contains(block);
    }

    public boolean isAir(Block block) {
        return block instanceof AirBlock;
    }

    public boolean isGrass(Block block) {
        return block instanceof GrassBlock || block instanceof MyceliumBlock;
    }

    private static Set<Block> create(Tag<Block> tag, Block def) {
        ObjectOpenHashSet set = new ObjectOpenHashSet(tag.func_199885_a());
        if (set.isEmpty() && def != null) {
            set.add((Object)def);
        }
        return ObjectSets.unmodifiable((ObjectSet)set);
    }

    public static float getHardness(BlockState state) {
        try (Resource<DummyBlockReader> reader = DummyBlockReader.pooled();){
            reader.get().set(state);
            float f = state.func_185887_b((IBlockReader)reader.get(), BlockPos.field_177992_a);
            return f;
        }
    }

    public static <T extends IForgeRegistryEntry<T>> List<T> toList(Collection<T> collection) {
        ArrayList<T> list = new ArrayList<T>(collection);
        list.sort(COMPARATOR);
        return Collections.unmodifiableList(list);
    }
}

