/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.concurrent.Resource;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.TerraBiomeProvider;
import com.terraforged.mod.chunk.TerraChunkGenerator;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.settings.SettingsHelper;
import com.terraforged.mod.data.DataGen;
import com.terraforged.mod.server.command.arg.BiomeArgType;
import com.terraforged.mod.server.command.arg.TerrainArgType;
import com.terraforged.mod.server.command.search.BiomeSearchTask;
import com.terraforged.mod.server.command.search.BothSearchTask;
import com.terraforged.mod.server.command.search.TerrainSearchTask;
import com.terraforged.world.WorldGenerator;
import com.terraforged.world.terrain.Terrain;
import com.terraforged.world.terrain.Terrains;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.ColumnFuzzedBiomeMagnifier;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TerraCommand {
    private static final Map<UUID, Integer> SEARCH_IDS = Collections.synchronizedMap(new HashMap());
    private static final BiFunction<UUID, Integer, Integer> INCREMENTER = (k, v) -> v == null ? 0 : v + 1;
    private static final TextFormatting TITLE_FORMAT = TextFormatting.ITALIC;
    private static final TextFormatting PREFIX_FORMAT = TextFormatting.GOLD;

    public static void init() {
        ArgumentTypes.func_218136_a((String)"terraforged:biome", BiomeArgType.class, (IArgumentSerializer)new ArgumentSerializer(BiomeArgType::new));
        ArgumentTypes.func_218136_a((String)"terraforged:terrain", TerrainArgType.class, (IArgumentSerializer)new ArgumentSerializer(TerrainArgType::new));
    }

    @SubscribeEvent
    public static void register(FMLServerStartingEvent event) {
        Log.info("Registering /terra command", new Object[0]);
        TerraCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void disconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        SEARCH_IDS.remove(event.getPlayer().func_110124_au());
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(TerraCommand.command());
    }

    private static LiteralArgumentBuilder<CommandSource> command() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"terra").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"query").executes(TerraCommand::query))).then(Commands.func_197057_a((String)"data").then(Commands.func_197057_a((String)"dump").executes(TerraCommand::dump)))).then(Commands.func_197057_a((String)"defaults").then(Commands.func_197057_a((String)"set").executes(TerraCommand::setDefaults)))).then(Commands.func_197057_a((String)"debug").executes(TerraCommand::debugBiome))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").then(Commands.func_197057_a((String)"biome").then(Commands.func_197056_a((String)"biome", BiomeArgType.biome()).executes(TerraCommand::findBiome)))).then(Commands.func_197057_a((String)"terrain").then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).executes(TerraCommand::findTerrain)))).then(Commands.func_197057_a((String)"both").then(Commands.func_197056_a((String)"biome", BiomeArgType.biome()).then(Commands.func_197056_a((String)"terrain", TerrainArgType.terrain()).executes(TerraCommand::findTerrainAndBiome)))));
    }

    private static int query(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        TerraBiomeProvider biomeProvider = TerraCommand.getBiomeProvider(context);
        try (Resource<Cell> cell = biomeProvider.lookupPos(pos.func_177958_n(), pos.func_177952_p());){
            Biome biome = biomeProvider.getBiome(cell.get(), pos.func_177958_n(), pos.func_177952_p());
            ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("At ").func_150257_a(TerraCommand.createTeleportMessage(pos)).func_150257_a((ITextComponent)new StringTextComponent(": Terrain = ")).func_150257_a(TerraCommand.createTitle(cell.get().terrain.getName())).func_150257_a((ITextComponent)new StringTextComponent(", Biome = ")).func_150257_a(TerraCommand.createTitle(biome.getRegistryName())).func_150257_a((ITextComponent)new StringTextComponent(", BiomeType = ")).func_150257_a(TerraCommand.createTitle(cell.get().biomeType.name())), false);
        }
        return 1;
    }

    private static int dump(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Exporting data"), true);
        DataGen.dumpData();
        return 1;
    }

    private static int setDefaults(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Setting generator defaults"), true);
        SettingsHelper.exportDefaults(terraContext.terraSettings);
        return 1;
    }

    private static int debugBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        BlockPos position = player.func_180425_c();
        int x = position.func_177958_n();
        int z = position.func_177952_p();
        long seed = player.func_71121_q().func_72905_C();
        Biome actual = player.func_71121_q().func_226691_t_(position);
        Biome biome2 = ColumnFuzzedBiomeMagnifier.INSTANCE.func_225532_a_(seed, x, 0, z, (BiomeManager.IBiomeReader)player.func_71121_q().getWorldServer().func_72863_F().func_201711_g().func_202090_b());
        ((CommandSource)context.getSource()).func_197030_a(new StringTextComponent("At ").func_150257_a(TerraCommand.createTeleportMessage(position)).func_150257_a((ITextComponent)new StringTextComponent(": Actual Biome = ")).func_150257_a(TerraCommand.createTitle(actual.getRegistryName())).func_150257_a((ITextComponent)new StringTextComponent(", Lookup Biome = ")).func_150257_a(TerraCommand.createTitle(biome2.getRegistryName())), false);
        return 1;
    }

    private static int findTerrain(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        Terrain terrain = TerrainArgType.getTerrain(context, "terrain");
        Terrain type = TerraCommand.getTerrainInstance(terrain, terraContext.terrain);
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        WorldGenerator generator = terraContext.factory.get();
        TerrainSearchTask search = new TerrainSearchTask(pos, type, TerraCommand.getChunkGenerator(context), generator);
        int identifier = TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a(TerraCommand.createPrefix(identifier).func_150257_a((ITextComponent)new StringTextComponent(" Searching for ")).func_150257_a(TerraCommand.createTitle(type.getName())).func_150257_a((ITextComponent)new StringTextComponent("...")), false);
        return 1;
    }

    private static int findBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        Biome biome = BiomeArgType.getBiome(context, "biome");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        ServerWorld world = ((CommandSource)context.getSource()).func_197035_h().func_71121_q();
        BiomeSearchTask search = new BiomeSearchTask(pos, biome, world.func_72863_F().func_201711_g(), TerraCommand.getBiomeProvider(context));
        int identifier = TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a(TerraCommand.createPrefix(identifier).func_150257_a((ITextComponent)new StringTextComponent(" Searching for ")).func_150257_a(TerraCommand.createTitle(biome.getRegistryName())).func_150257_a((ITextComponent)new StringTextComponent("...")), false);
        return 1;
    }

    private static int findTerrainAndBiome(CommandContext<CommandSource> context) throws CommandSyntaxException {
        TerraContext terraContext = TerraCommand.getContext(context).orElseThrow(() -> TerraCommand.createException("Invalid world type", "This command can only be run in a TerraForged world!", new Object[0]));
        Terrain terrain = TerrainArgType.getTerrain(context, "terrain");
        Terrain target = TerraCommand.getTerrainInstance(terrain, terraContext.terrain);
        Biome biome = BiomeArgType.getBiome(context, "biome");
        BlockPos pos = ((CommandSource)context.getSource()).func_197035_h().func_180425_c();
        UUID playerID = ((CommandSource)context.getSource()).func_197035_h().func_110124_au();
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        WorldGenerator generator = terraContext.factory.get();
        BiomeSearchTask biomeSearch = new BiomeSearchTask(pos, biome, TerraCommand.getChunkGenerator(context), TerraCommand.getBiomeProvider(context));
        TerrainSearchTask terrainSearch = new TerrainSearchTask(pos, target, TerraCommand.getChunkGenerator(context), generator);
        BothSearchTask search = new BothSearchTask(pos, biomeSearch, terrainSearch);
        int identifier = TerraCommand.doSearch(server, playerID, search);
        ((CommandSource)context.getSource()).func_197030_a(TerraCommand.createPrefix(identifier).func_150257_a((ITextComponent)new StringTextComponent(" Searching for ")).func_150257_a(TerraCommand.createTitle(biome.getRegistryName())).func_150257_a((ITextComponent)new StringTextComponent(" and ")).func_150257_a(TerraCommand.createTitle(target.getName())).func_150257_a((ITextComponent)new StringTextComponent("...")), false);
        return 1;
    }

    private static int doSearch(MinecraftServer server, UUID userId, Supplier<BlockPos> supplier) {
        int identifier = SEARCH_IDS.compute(userId, INCREMENTER);
        CompletableFuture.supplyAsync(supplier).thenAccept(pos -> server.func_213165_a(() -> {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(userId);
            if (player == null) {
                SEARCH_IDS.remove(userId);
                return;
            }
            if (pos == BlockPos.field_177992_a) {
                player.func_145747_a(TerraCommand.createPrefix(identifier).func_150257_a((ITextComponent)new StringTextComponent(" Location not found :[")));
                return;
            }
            double distance = Math.sqrt(player.func_180425_c().func_177951_i((Vec3i)pos));
            ITextComponent result = TerraCommand.createPrefix(identifier).func_150257_a((ITextComponent)new StringTextComponent(" Nearest match: ")).func_150257_a(TerraCommand.createTeleportMessage(pos)).func_150257_a((ITextComponent)new StringTextComponent(String.format(" Distance: %.2f", distance)));
            player.func_145747_a(result);
        }));
        return identifier;
    }

    private static Optional<TerraContext> getContext(CommandContext<CommandSource> context) throws CommandSyntaxException {
        DimensionType dimension;
        MinecraftServer server = ((CommandSource)context.getSource()).func_197028_i();
        ChunkGenerator generator = server.func_71218_a(dimension = ((CommandSource)context.getSource()).func_197035_h().field_71093_bK).func_72863_F().func_201711_g();
        if (generator instanceof TerraChunkGenerator) {
            TerraChunkGenerator gen = (TerraChunkGenerator)generator;
            return Optional.of(gen.getContext());
        }
        return Optional.empty();
    }

    private static Terrain getTerrainInstance(Terrain find, Terrains terrains) {
        for (Terrain t : terrains.index) {
            if (!t.getName().equals(find.getName())) continue;
            return t;
        }
        return find;
    }

    private static ChunkGenerator<?> getChunkGenerator(CommandContext<CommandSource> context) {
        return ((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_201711_g();
    }

    private static TerraBiomeProvider getBiomeProvider(CommandContext<CommandSource> context) {
        return (TerraBiomeProvider)((CommandSource)context.getSource()).func_197023_e().func_72863_F().func_201711_g().func_202090_b();
    }

    private static CommandSyntaxException createException(String type, String message, Object ... args) {
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent(type)), (Message)new StringTextComponent(String.format(message, args)));
    }

    private static ITextComponent createTeleportMessage(BlockPos pos) {
        return TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
    }

    private static ITextComponent createPrefix(int identifier) {
        return new StringTextComponent("").func_150257_a(TextComponentUtils.func_197676_a((ITextComponent)new StringTextComponent(String.format("%03d", identifier))).func_211708_a(PREFIX_FORMAT));
    }

    private static ITextComponent createTitle(@Nullable Object name) {
        String title = name == null ? "null" : name.toString();
        return new StringTextComponent("").func_150257_a(new StringTextComponent(title).func_211708_a(TITLE_FORMAT));
    }
}

