/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.server.command.arg;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeArgType
implements ArgumentType<Biome> {
    public Biome parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.func_195826_a((StringReader)reader);
        return (Biome)Registry.field_212624_m.func_218349_b(resourcelocation).orElseThrow(() -> BiomeArgType.createException("Invalid biome", "%s is not a valid biome", resourcelocation));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestions) {
        return ISuggestionProvider.func_197014_a((Iterable)ForgeRegistries.BIOMES.getKeys(), (SuggestionsBuilder)suggestions);
    }

    private static CommandSyntaxException createException(String type, String message, Object ... args) {
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent(type)), (Message)new StringTextComponent(String.format(message, args)));
    }

    public static ArgumentType<Biome> biome() {
        return new BiomeArgType();
    }

    public static <S> Biome getBiome(CommandContext<S> context, String name) {
        return (Biome)context.getArgument(name, Biome.class);
    }
}

