/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

public abstract class RangeModifier {
    protected final float from;
    protected final float to;
    protected final float max;
    private final float range;

    public RangeModifier(float from, float max, boolean exclusive) {
        this.from = from;
        this.to = max;
        this.max = exclusive ? 0.0f : 1.0f;
        this.range = Math.abs(max - from);
    }

    public float apply(float value) {
        if (this.from < this.to) {
            if (value <= this.from) {
                return 0.0f;
            }
            if (value >= this.to) {
                return this.max;
            }
            return (value - this.from) / this.range;
        }
        if (this.from > this.to) {
            if (value <= this.to) {
                return this.max;
            }
            if (value >= this.from) {
                return 0.0f;
            }
            return 1.0f - (value - this.to) / this.range;
        }
        return 0.0f;
    }
}

