/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.terraforged.core.util.NameUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;

public class TranslationKey {
    private static final Map<String, TranslationKey> keys = new HashMap<String, TranslationKey>();
    private final String translationKey;
    private final String defaultValue;

    public TranslationKey(String key, String display) {
        this.translationKey = key;
        this.defaultValue = display;
        keys.put(this.translationKey, this);
    }

    public String getKey() {
        return this.translationKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String get() {
        if (I18n.func_188566_a((String)this.translationKey)) {
            return I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0]);
        }
        return this.defaultValue;
    }

    public String get(Object ... args) {
        if (I18n.func_188566_a((String)this.translationKey)) {
            return I18n.func_135052_a((String)this.translationKey, (Object[])args);
        }
        return this.defaultValue;
    }

    public static void each(Consumer<TranslationKey> consumer) {
        keys.values().stream().sorted(Comparator.comparing(TranslationKey::getKey)).forEach(consumer);
    }

    public static TranslationKey gui(String text) {
        String key = NameUtil.toDisplayNameKey(text);
        String display = NameUtil.toDisplayName(text.substring(text.lastIndexOf(46) + 1));
        return new TranslationKey(key, display);
    }

    public static TranslationKey gui(String key, String display) {
        return new TranslationKey(NameUtil.toDisplayNameKey(key), display);
    }
}

