/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.nbt;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import com.terraforged.core.serialization.serializer.Serializer;
import com.terraforged.mod.util.nbt.NBTReader;
import com.terraforged.mod.util.nbt.NBTWriter;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;

public class NBTHelper {
    public static JsonElement toJson(CompoundNBT tag) {
        Dynamic input = new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag);
        Dynamic output = input.convert((DynamicOps)JsonOps.INSTANCE);
        return (JsonElement)output.getValue();
    }

    public static CompoundNBT fromJson(JsonElement json) {
        Dynamic input = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json);
        Dynamic output = input.convert((DynamicOps)NBTDynamicOps.field_210820_a);
        return (CompoundNBT)output.getValue();
    }

    public static CompoundNBT serialize(Object object) {
        return NBTHelper.serialize("", object);
    }

    public static CompoundNBT serialize(String owner, Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            Serializer.serialize(object, writer, owner, true);
            return writer.compound();
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static CompoundNBT serializeCompact(Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            writer.readFrom(object);
            return NBTHelper.stripMetadata(writer.compound());
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static CompoundNBT readCompact(Object object) {
        try {
            NBTWriter writer = new NBTWriter();
            writer.readFrom(object);
            new Serializer();
            Serializer.serialize(object, writer);
            return writer.compound();
        }
        catch (IllegalAccessException e) {
            return new CompoundNBT();
        }
    }

    public static Stream<String> streamkeys(CompoundNBT compound) {
        return compound.func_150296_c().stream().filter(name -> !name.startsWith("#")).sorted(Comparator.comparing(name -> compound.func_74775_l("#" + name).func_74762_e("order")));
    }

    public static <T extends INBT> T stripMetadata(T tag) {
        block4: {
            block3: {
                if (!(tag instanceof CompoundNBT)) break block3;
                CompoundNBT compound = (CompoundNBT)tag;
                LinkedList keys = new LinkedList(compound.func_150296_c());
                for (String key : keys) {
                    if (key.charAt(0) == '#') {
                        compound.func_82580_o(key);
                        continue;
                    }
                    NBTHelper.stripMetadata(compound.func_74781_a(key));
                }
                break block4;
            }
            if (!(tag instanceof ListNBT)) break block4;
            ListNBT list = (ListNBT)tag;
            for (int i = 0; i < list.size(); ++i) {
                NBTHelper.stripMetadata(list.get(i));
            }
        }
        return tag;
    }

    public static boolean deserialize(CompoundNBT settings, Object object) {
        try {
            NBTReader reader = new NBTReader((INBT)settings);
            return reader.writeTo(object);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }
}

