/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.func;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.func.CurveFunc;
import com.terraforged.n2d.util.NoiseUtil;

public enum Interpolation implements CurveFunc
{
    LINEAR{

        @Override
        public float apply(float f) {
            return f;
        }
    }
    ,
    CURVE3{

        @Override
        public float apply(float f) {
            return NoiseUtil.interpHermite(f);
        }
    }
    ,
    CURVE4{

        @Override
        public float apply(float f) {
            return NoiseUtil.interpQuintic(f);
        }
    };

    private static final DataFactory<Interpolation> factory;

    @Override
    public String getSpecName() {
        return "Interp";
    }

    @Override
    public abstract float apply(float var1);

    public static DataSpec<Interpolation> spec() {
        return DataSpec.builder("Interp", Interpolation.class, factory).add("name", LINEAR.name(), i -> i).build();
    }

    static {
        factory = (data, spec, context) -> spec.get("name", data, v -> v.asEnum(Interpolation.class));
    }
}

