/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.modifier;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.modifier.Modifier;

public class Map
extends Modifier {
    private final Module min;
    private final Module max;
    private final float sourceRange;
    private static final DataFactory<Map> factory = (data, spec, context) -> new Map(spec.get("source", data, Module.class, context), spec.get("min", data, Module.class, context), spec.get("max", data, Module.class, context));

    public Map(Module source, Module min, Module max) {
        super(source);
        this.min = min;
        this.max = max;
        this.sourceRange = source.maxValue() - source.minValue();
    }

    @Override
    public String getSpecName() {
        return "Map";
    }

    @Override
    public float minValue() {
        return this.min.minValue();
    }

    @Override
    public float maxValue() {
        return this.max.maxValue();
    }

    @Override
    public float modify(float x, float y, float value) {
        float alpha = (value - this.source.minValue()) / this.sourceRange;
        float min = this.min.getValue(x, y);
        float max = this.max.getValue(x, y);
        return min + alpha * (max - min);
    }

    public static DataSpec<Map> spec() {
        return Modifier.sourceBuilder(Map.class, factory).addObj("min", Module.class, m -> m.min).addObj("max", Module.class, m -> m.max).build();
    }
}

