/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.modifier;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.modifier.Modifier;
import com.terraforged.n2d.util.NoiseUtil;

public class Power
extends Modifier {
    private final Module n;
    public static final DataFactory<Power> factory = (data, spec, context) -> new Power(spec.get("source", data, Module.class, context), spec.get("power", data, Module.class, context));

    public Power(Module source, Module n) {
        super(source);
        this.n = n;
    }

    @Override
    public String getSpecName() {
        return "Pow";
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        return NoiseUtil.pow(noiseValue, this.n.getValue(x, y));
    }

    public static DataSpec<Power> spec() {
        return Power.sourceBuilder("Pow", Power.class, factory).addObj("power", Module.class, p -> p.n).build();
    }
}

