/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.modifier;

import com.terraforged.cereal.spec.DataFactory;
import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.modifier.Modifier;

public class Scale
extends Modifier {
    private final Module scale;
    private final float min;
    private final float max;
    private static final DataFactory<Scale> factory = (data, spec, context) -> new Scale(spec.get("source", data, Module.class, context), spec.get("scale", data, Module.class, context));

    public Scale(Module source, Module scale) {
        super(source);
        this.scale = scale;
        this.min = source.minValue() * scale.minValue();
        this.max = source.maxValue() * scale.maxValue();
    }

    @Override
    public String getSpecName() {
        return "Scale";
    }

    @Override
    public float minValue() {
        return this.min;
    }

    @Override
    public float maxValue() {
        return this.max;
    }

    @Override
    public float modify(float x, float y, float noiseValue) {
        return noiseValue * this.scale.getValue(x, y);
    }

    public static DataSpec<Scale> spec() {
        return Modifier.sourceBuilder(Scale.class, factory).addObj("scale", Module.class, s -> s.scale).build();
    }
}

