/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.source;

import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.Module;
import com.terraforged.n2d.func.CellFunc;
import com.terraforged.n2d.func.DistanceFunc;
import com.terraforged.n2d.source.Builder;
import com.terraforged.n2d.source.FastSource;
import com.terraforged.n2d.util.Noise;
import com.terraforged.n2d.util.NoiseUtil;

public class FastCell
extends FastSource {
    private final Module lookup;
    private final CellFunc cellFunc;
    private final DistanceFunc distFunc;
    private final float min;
    private final float max;
    private final float range;

    public FastCell(Builder builder) {
        super(builder);
        this.lookup = builder.getSource();
        this.cellFunc = builder.getCellFunc();
        this.distFunc = builder.getDistFunc();
        this.min = FastCell.min(this.cellFunc, this.lookup);
        this.max = FastCell.max(this.cellFunc, this.lookup);
        this.range = this.max - this.min;
    }

    @Override
    public String getSpecName() {
        return "Cell";
    }

    @Override
    public float getValue(float x, float y, int seed) {
        float value = Noise.cell(x *= this.frequency, y *= this.frequency, seed, this.cellFunc, this.distFunc, this.lookup);
        if (this.cellFunc != CellFunc.NOISE_LOOKUP) {
            return NoiseUtil.map(value, this.min, this.max, this.range);
        }
        return value;
    }

    static float min(CellFunc func, Module lookup) {
        if (func == CellFunc.NOISE_LOOKUP) {
            return lookup.minValue();
        }
        if (func == CellFunc.DISTANCE) {
            return -1.0f;
        }
        return -1.0f;
    }

    static float max(CellFunc func, Module lookup) {
        if (func == CellFunc.NOISE_LOOKUP) {
            return lookup.maxValue();
        }
        if (func == CellFunc.DISTANCE) {
            return 0.25f;
        }
        return 1.0f;
    }

    public static DataSpec<FastCell> spec() {
        return FastCell.specBuilder("Cell", FastCell.class, FastCell::new).add("cell_func", (Object)Builder.DEFAULT_CELL_FUNC, f -> f.cellFunc.name()).add("dist_func", (Object)Builder.DEFAULT_DIST_FUNC, f -> f.distFunc.name()).addObj("source", Module.class, f -> f.lookup).build();
    }
}

