/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.source;

import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.func.DistanceFunc;
import com.terraforged.n2d.func.EdgeFunc;
import com.terraforged.n2d.source.Builder;
import com.terraforged.n2d.source.FastSource;
import com.terraforged.n2d.util.Noise;
import com.terraforged.n2d.util.NoiseUtil;

public class FastCellEdge
extends FastSource {
    private final EdgeFunc edgeFunc;
    private final DistanceFunc distFunc;

    public FastCellEdge(Builder builder) {
        super(builder);
        this.edgeFunc = builder.getEdgeFunc();
        this.distFunc = builder.getDistFunc();
    }

    @Override
    public String getSpecName() {
        return "CellEdge";
    }

    @Override
    public float getValue(float x, float y, int seed) {
        float value = Noise.cellEdge(x *= this.frequency, y *= this.frequency, seed, this.edgeFunc, this.distFunc);
        return NoiseUtil.map(value, this.edgeFunc.min(), this.edgeFunc.max(), this.edgeFunc.range());
    }

    public static DataSpec<FastCellEdge> spec() {
        return FastCellEdge.specBuilder("CellEdge", FastCellEdge.class, FastCellEdge::new).add("edge_func", (Object)Builder.DEFAULT_EDGE_FUNC, f -> f.edgeFunc.name()).add("dist_func", (Object)Builder.DEFAULT_DIST_FUNC, f -> f.distFunc.name()).build();
    }
}

