/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.source;

import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.func.Interpolation;
import com.terraforged.n2d.source.Builder;
import com.terraforged.n2d.source.FastSource;
import com.terraforged.n2d.util.Noise;
import com.terraforged.n2d.util.NoiseUtil;

public class FastRidge
extends FastSource {
    private static final int RIDGED_MAX_OCTAVE = 30;
    private final Interpolation interpolation;
    private final float[] spectralWeights;
    private final float min;
    private final float max;
    private final float range;

    public FastRidge(Builder builder) {
        super(builder);
        this.interpolation = builder.getInterp();
        this.spectralWeights = new float[30];
        float h = 1.0f;
        float frequency = 1.0f;
        for (int i = 0; i < 30; ++i) {
            this.spectralWeights[i] = NoiseUtil.pow(frequency, -h);
            frequency *= this.lacunarity;
        }
        this.min = 0.0f;
        this.max = this.calculateBound(0.0f, builder.getOctaves(), builder.getGain());
        this.range = Math.abs(this.max - this.min);
    }

    @Override
    public String getSpecName() {
        return "Ridge";
    }

    @Override
    public float getValue(float x, float y, int seed) {
        x *= this.frequency;
        y *= this.frequency;
        float value = 0.0f;
        float weight = 1.0f;
        float offset = 1.0f;
        float amp = 2.0f;
        for (int octave = 0; octave < this.octaves; ++octave) {
            float signal = Noise.singlePerlin(x, y, seed + octave, this.interpolation);
            signal = Math.abs(signal);
            signal = offset - signal;
            signal *= signal;
            signal *= weight;
            weight = signal * amp;
            weight = NoiseUtil.clamp(weight, 0.0f, 1.0f);
            value += signal * this.spectralWeights[octave];
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(value, this.min, this.max, this.range);
    }

    private float calculateBound(float signal, int octaves, float gain) {
        float value = 0.0f;
        float weight = 1.0f;
        float amp = 2.0f;
        float offset = 1.0f;
        for (int curOctave = 0; curOctave < octaves; ++curOctave) {
            float noise = signal;
            noise = Math.abs(noise);
            noise = offset - noise;
            noise *= noise;
            noise *= weight;
            weight = noise * amp;
            weight = Math.min(1.0f, Math.max(0.0f, weight));
            value += noise * this.spectralWeights[curOctave];
            amp *= gain;
        }
        return value;
    }

    public static DataSpec<FastRidge> ridgeSpec() {
        return FastRidge.specBuilder("Ridge", FastRidge.class, FastRidge::new).build();
    }
}

