/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.n2d.source;

import com.terraforged.cereal.spec.DataSpec;
import com.terraforged.n2d.source.Builder;
import com.terraforged.n2d.source.FastSource;
import com.terraforged.n2d.util.Noise;
import com.terraforged.n2d.util.NoiseUtil;

public class FastSimplex
extends FastSource {
    private final float min;
    private final float max;
    private final float range;
    private static final float[] signals = new float[]{1.0f, 0.989f, 0.81f, 0.781f, 0.708f, 0.702f, 0.696f};

    public FastSimplex(Builder builder) {
        super(builder);
        this.min = -FastSimplex.max(builder.getOctaves(), builder.getGain());
        this.max = FastSimplex.max(builder.getOctaves(), builder.getGain());
        this.range = this.max - this.min;
    }

    @Override
    public String getSpecName() {
        return "Simplex";
    }

    @Override
    public float getValue(float x, float y, int seed) {
        x *= this.frequency;
        y *= this.frequency;
        float sum = 0.0f;
        float amp = 1.0f;
        for (int i = 0; i < this.octaves; ++i) {
            sum += Noise.singleSimplex(x, y, seed + i, this.interpolation) * amp;
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return NoiseUtil.map(sum, this.min, this.max, this.range);
    }

    private static float max(int octaves, float gain) {
        float signal = FastSimplex.signal(octaves);
        float sum = 0.0f;
        float amp = 1.0f;
        for (int i = 0; i < octaves; ++i) {
            sum += amp * signal;
            amp *= gain;
        }
        return sum;
    }

    private static float signal(int octaves) {
        int index = Math.min(octaves, signals.length - 1);
        return signals[index];
    }

    public static DataSpec<FastSimplex> spec() {
        return FastSimplex.specBuilder("Simplex", FastSimplex.class, FastSimplex::new).build();
    }
}

