/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world;

import com.terraforged.core.Seed;
import com.terraforged.core.concurrent.thread.ThreadPools;
import com.terraforged.core.settings.Settings;
import com.terraforged.core.tile.gen.TileCache;
import com.terraforged.core.tile.gen.TileGenerator;
import com.terraforged.world.WorldGeneratorFactory;
import com.terraforged.world.heightmap.Levels;
import com.terraforged.world.terrain.Terrains;
import com.terraforged.world.terrain.provider.StandardTerrainProvider;
import com.terraforged.world.terrain.provider.TerrainProviderFactory;
import java.util.function.Function;

public class GeneratorContext {
    public final Seed seed;
    public final Levels levels;
    public final Terrains terrain;
    public final Settings settings;
    public final TileCache cache;
    public final WorldGeneratorFactory factory;
    public final TerrainProviderFactory terrainFactory;

    public GeneratorContext(Terrains terrain, Settings settings) {
        this(terrain, settings, StandardTerrainProvider::new, GeneratorContext::createCache);
    }

    public <T extends Settings> GeneratorContext(Terrains terrain, T settings, TerrainProviderFactory terrainFactory, Function<WorldGeneratorFactory, TileCache> cache) {
        this.terrain = terrain;
        this.settings = settings;
        this.seed = new Seed(settings.world.seed);
        this.levels = new Levels(settings.world);
        this.terrainFactory = terrainFactory;
        this.factory = this.createFactory(this);
        this.cache = cache.apply(this.factory);
    }

    private GeneratorContext(GeneratorContext src) {
        this.seed = new Seed(src.seed.get());
        this.cache = src.cache;
        this.levels = src.levels;
        this.factory = src.factory;
        this.terrain = src.terrain;
        this.settings = src.settings;
        this.terrainFactory = src.terrainFactory;
    }

    protected WorldGeneratorFactory createFactory(GeneratorContext context) {
        return new WorldGeneratorFactory(context);
    }

    public GeneratorContext copy() {
        return new GeneratorContext(this);
    }

    public static GeneratorContext createNoCache(Terrains terrain, Settings settings) {
        return new GeneratorContext(terrain, settings, StandardTerrainProvider::new, s -> null);
    }

    protected static <T extends Settings> TileCache createCache(WorldGeneratorFactory factory) {
        return TileGenerator.builder().factory(factory).size(3, 2).pool(ThreadPools.createDefault()).build().toCache(false);
    }
}

