/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.continent.generator;

import com.terraforged.core.Seed;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.settings.WorldSettings;
import com.terraforged.n2d.util.Vec2i;
import com.terraforged.world.continent.MutableVeci;
import com.terraforged.world.continent.generator.ContinentGenerator;

public class SingleContinentGenerator
extends ContinentGenerator {
    private final Vec2i center;

    public SingleContinentGenerator(Seed seed, WorldSettings settings) {
        super(seed, settings);
        MutableVeci pos = new MutableVeci();
        this.getNearestCenter(0.0f, 0.0f, pos);
        this.center = new Vec2i(pos.x, pos.z);
    }

    @Override
    public void apply(Cell cell, float x, float y) {
        super.apply(cell, x, y);
        if (cell.continentX != this.center.x || cell.continentZ != this.center.y) {
            cell.continentIdentity = 0.0f;
            cell.continentEdge = 0.0f;
            cell.continentX = 0;
            cell.continentZ = 0;
        }
    }
}

