/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.world.rivermap.river;

import com.terraforged.n2d.source.Line;
import com.terraforged.n2d.util.NoiseUtil;
import com.terraforged.n2d.util.Vec2f;
import com.terraforged.n2d.util.Vec2i;

public class RiverBounds {
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private final int minX;
    private final int minY;
    private final int maxX;
    private final int maxY;
    private final float length;

    public RiverBounds(int x1, int y1, int x2, int y2) {
        this(x1, y1, x2, y2, 0);
    }

    public RiverBounds(int x1, int y1, int x2, int y2, int radius) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.length = this.length();
    }

    public int x1() {
        return this.x1;
    }

    public int y1() {
        return this.y1;
    }

    public int x2() {
        return this.x2;
    }

    public int y2() {
        return this.y2;
    }

    public float length() {
        int dx = this.x1 - this.x2;
        int dy = this.y1 - this.y2;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public boolean intersects(RiverBounds other) {
        return Line.intersect(other.x1, other.y1, other.x2, other.y2, this.x1, this.y1, this.x2, this.y2);
    }

    public boolean intersects(RiverBounds other, float extend) {
        float extendA = NoiseUtil.clamp(extend / this.length, 0.0f, 1.0f);
        float extendB = NoiseUtil.clamp(extend / other.length, 0.0f, 1.0f);
        int deltaAX = this.x2 - this.x1;
        int deltaAY = this.y2 - this.y1;
        int deltaBX = other.x2 - other.x1;
        int deltaBY = other.y2 - other.y1;
        float ax1 = (float)this.x1 - (float)deltaAX * extendA;
        float ax2 = (float)this.x2 + (float)deltaAX * extendA;
        float ay1 = (float)this.y1 - (float)deltaAY * extendA;
        float ay2 = (float)this.y2 + (float)deltaAY * extendA;
        float bx1 = (float)other.x1 - (float)deltaBX * extendB;
        float bx2 = (float)other.x2 + (float)deltaBX * extendB;
        float by1 = (float)other.y1 - (float)deltaBY * extendB;
        float by2 = (float)other.y2 + (float)deltaBY * extendB;
        return Line.intersect(ax1, ay1, ax2, ay2, bx1, by1, bx2, by2);
    }

    public boolean overlaps(RiverBounds other) {
        return this.overlaps(other.minX, other.minY, other.maxX, other.maxY);
    }

    public boolean overlaps(float minX, float minY, float maxX, float maxY) {
        return (float)this.minX < maxX && (float)this.maxX > minX && (float)this.minY < maxY && (float)this.maxY > minY;
    }

    public boolean overlaps(Vec2f center, float radius) {
        float minX = center.x - radius;
        float maxX = center.x + radius;
        float minY = center.y - radius;
        float maxY = center.y + radius;
        return this.overlaps(minX, minY, maxX, maxY);
    }

    public Vec2f pos(float distance) {
        int dx = this.x2() - this.x1();
        int dy = this.y2() - this.y1();
        return new Vec2f((float)this.x1() + (float)dx * distance, (float)this.y1() + (float)dy * distance);
    }

    public RiverBounds shorten(int distance) {
        float factor = (float)distance / this.length();
        int dx = this.x2() - this.x1();
        int dy = this.y2() - this.y1();
        int x = NoiseUtil.round((float)this.x1 + (float)dx * factor);
        int y = NoiseUtil.round((float)this.y1 + (float)dy * factor);
        return new RiverBounds(x, y, this.x2, this.y2);
    }

    public static RiverBounds fromNodes(Vec2i p1, Vec2i p2) {
        return new RiverBounds(p1.x, p1.y, p2.x, p2.y, 300);
    }
}

